﻿var map; //Aktuelle Landkarte

var myGeoJSON =
    {
        "type": "FeatureCollection",
        "crs": { "type": "name", "properties": { "name": 'EPSG:3857' } },
        "features": [
            {
                "type": "Feature",
                "geometry": {
                    "type": "Point",
                    "coordinates": [1346620.74818,6277780.37823] //[4e6, -2e6]
                },
                "properties": {
                    "id":0,
                    "title": "alpha Café"
                }
            }
        ]
    };

var geoJSONSource;

function start(locationControl) {
    initializeMap();
    initializeGeolocation(locationControl);
    addGeoJSONLayer();
}

function initializeMap() {
    map = new ol.Map({
        target: 'map',
        layers: [
        new ol.layer.Tile({
            source: new ol.source.OSM()
        })
        ],
        controls: ol.control.defaults().extend([new ol.control.ScaleLine(),
                                                new ol.control.FullScreen()]),
        view: new ol.View({
            center: ol.proj.transform([12.0969, 49.0172], 'EPSG:4326', 'EPSG:3857'),
            zoom: 6
        })
    });

   
}

var geoJSONLayer;

function addGeoJSONLayer() {

    loadLocalJSON();

    geoJSONSource = new ol.source.GeoJSON({
        object: myGeoJSON
    });

    geoJSONLayer = new ol.layer.Vector({
        title: 'Restaurants',
        source: geoJSONSource,
        style: createPointStyleFunction()
    });

    map.addLayer(geoJSONLayer);

}


function initializeInfo() {
    var info = document.getElementById('info');

    var popup = new ol.Overlay({
        element: info,
        positioning: 'bottom-center',
        stopEvent: false
    });
    map.addOverlay(popup);

    map.on('dblclick', function (evt) {
        var feature = map.forEachFeatureAtPixel(evt.pixel,
            function (feature, layer) {
                return feature;
            });
        info = document.getElementById('info');
        if (feature) {
            var geometry = feature.getGeometry();
            var coord = geometry.getCoordinates();
            popup.setPosition(coord);
            info.innerHTML = feature.get('title');
        } else {
            info.innerHTML = '';
        }
    });
}


function ShowFeatureInfo(feature) {
    var geometry = feature.getGeometry();
    var geometryName = feature.getGeometryName();
    var properties = feature.getProperties();
    var test = 1;
}

function loadLocalJSON() {

    if ('localStorage' in window && window['localStorage'] !== null) { //Wenn localStorage in Browser vorhanden

        var localData = localStorage.getItem("MyLayer");

        if (localData == null) {
            alert('Kein Layer in localStorage gespeicher!');
        } else {
            myGeoJSON = JSON.parse(localData);
        }
    } else {
        alert('Browser unterstütz nicht localStorage!');
    }
}

function saveLocalJSON() {
    var geojson = new ol.format.GeoJSON();
    var features = geoJSONSource.getFeatures();
    var geojsonobject = geojson.writeFeatures(features);
    var dataToStore = JSON.stringify(geojsonobject);
    localStorage.setItem('MyLayer', dataToStore);
}

function clearLocalJSON() {
    localStorage.removeItem('MyLayer');
}

function addFeatureDirect() { //Fügt ein neues Objekt in den Layer ein, ohne mit der Oberfläche zusammen zu arbeiten
    var newFeature = new ol.Feature({
        geometry: new ol.geom.Point(ol.proj.transform([-73.1234, 45.678], 'EPSG:4326',
        'EPSG:3857')),
        title: 'NEXT Kaffee',
        id: 1
    });
    geoJSONSource.addFeature(newFeature);
}

//---- Restaurant hinzufügen

var drawInteraction;

function addFeature() {
    drawInteraction = new ol.interaction.Draw({
        type: 'Point',
        source: geoJSONSource
    });

    drawInteraction.on('drawend', function (evt) {

        var newFeature = evt.feature;
        var title = prompt("Neues Restaurant","<Neuer Name>");
        newFeature.setProperties({
            title: title,
            id: geoJSONSource.getFeatures().length
        })
        map.removeInteraction(drawInteraction);
        saveLocalJSON();
    });

    map.addInteraction(drawInteraction);
}

//Style
var createPointStyleFunction = function () {
    return function (feature, resolution) {
        var style = new ol.style.Style({
            image: new ol.style.Circle({
                radius: 5,
                fill: new ol.style.Fill({ color: 'rgba(255, 0, 0, 0.1)' }),
                stroke: new ol.style.Stroke({ color: 'red', width: 1 })
            }),
            text: createTextStyle(feature, resolution)
        });
        return [style];
    };
};

var createTextStyle = function (feature, resolution) {
    return new ol.style.Text({
        textAlign: 'Center',
        textBaseline: 'Middle',
        font: '12px Calibri,sans-serif',
        text: feature.get('title'),
        fill: new ol.style.Fill({ color: 'blue' }),
        stroke: new ol.style.Stroke({ color: '#fff', width: 3}),
        offsetX: 0,
        offsetY: 0,
        rotation: 0
    });
};


//Geolocation
var myGeolocation;

function initializeGeolocation(locationControl) {

    myGeolocation = new ol.Geolocation({
        projection: map.getView().getProjection(),
        trackingOptions: {
            maximumAge: 10000,
            enableHighAccuracy: true,
            timeout: 600000
        }
    });

    if (locationControl != undefined) {
        var track = new ol.dom.Input(document.getElementById(locationControl)); //Helper class for binding HTML input to an ol.Object.
        track.bindTo('checked', myGeolocation, 'tracking'); //Checkbox mit Attribut geolocation.tracking verbinden
    }

    // update the HTML page when the position changes.
    myGeolocation.on('change', function () {
        var accuracy = myGeolocation.getAccuracy();
        var altitude = myGeolocation.getAltitude();
        var altitudeAccuracy = myGeolocation.getAltitudeAccuracy();
        var heading = myGeolocation.getHeading();
        var speed = myGeolocation.getSpeed();
    });

    // handle geolocation error.
    myGeolocation.on('error', function (error) {
        alert(error.message);
    });

    var accuracyFeature = new ol.Feature();
    accuracyFeature.bindTo('geometry', myGeolocation, 'accuracyGeometry');

    var positionFeature = new ol.Feature();
    positionFeature.bindTo('geometry', myGeolocation, 'position')
        .transform(function () { }, function (coordinates) {
            return coordinates ? new ol.geom.Point(coordinates) : null;
        });

    var featuresOverlay = new ol.FeatureOverlay({
        map: map,
        features: [accuracyFeature, positionFeature]
    });

}

function setGeolocationOn(){
    myGeolocation.setTracking(true);
}

var borderLayer;

function showBorder(radioControl) {
    var borderType = radioControl.value;

    if (borderLayer != null) {
        map.removeLayer(borderLayer);
    }

    if (borderType != "ohne") {

        var layers = '0'; //Bundesländer

        if (borderType == 'landkreis') {
            layers = '1';
        }

        borderLayer = new ol.layer.Tile({
            source: new ol.source.TileWMS({
            attributions: [new ol.Attribution({
            html: '&copy; ' +
                        '<a href="http://www.bkg.bund.de">' +
                        'Bundesamt für Kartographie und Geodäsie</a>'
        })],
            crossOrigin: 'anonymous',
            params: {
                    'LAYERS': layers,
                    'FORMAT': 'image/png'
        },
            url: 'http://sg.geodatenzentrum.de/wms_vg2500?'
        }),
            opacity: 0.8
        });
        
        //map.addLayer(borderLayer);
        var layerList = map.getLayers();
        layerList.insertAt(1, borderLayer);
    }
}


