﻿using System.Collections.Generic;

namespace ConferenceApp
{
    public class Repository : ModelBase
    {
        private static Repository _current;
        private static object _lockObject = new object();

        private Repository()
        {
            this.Topics = new List<string>
			{
				"Agenda",
				"Sprecher",
				"Vorträge"
			};
            this.Agenda = new List<AgendaEntry>
			{
				new AgendaEntry { Time = "08:00 - 09:00", Track = "Registrierung der Teilnehmer" },
				new AgendaEntry { Time = "08:15 - 08:45", Track = "Exklusives Business Breakfast (optional)" },
				new AgendaEntry { Time = "09:00 - 09:15", Track = "Begrüßung" },
				new AgendaEntry { Time = "09:15 - 10:10", Track = "Session" },
				new AgendaEntry { Time = "10:10 - 10:40", Track = "Kaffeepause" },
				new AgendaEntry { Time = "10:40 - 11:35", Track = "Session" },
				new AgendaEntry { Time = "11:35 - 12:30", Track = "Session" },
				new AgendaEntry { Time = "12:30 - 13:45", Track = "Mittagspause" },
				new AgendaEntry { Time = "12:30 - 13:00", Track = "Exklusiver Business Lunch (optional)" },
				new AgendaEntry { Time = "13:45 - 14:40", Track = "Session" },
				new AgendaEntry { Time = "14:40 - 15:35", Track = "Session" },
				new AgendaEntry { Time = "15:35 - 16:05", Track = "Kaffeepause" },
				new AgendaEntry { Time = "16:05 - 17:00", Track = "Session" },
				new AgendaEntry { Time = "17:00 - 17:55", Track = "Session" },
				new AgendaEntry { Time = "17:55 - 18:55", Track = "Ende des Konferenzprogramms" },
			};
            this.Speakers = new List<Speaker>()
			{
				new Speaker { Name = "Volker Weber, freiberuflicher Systemarchitekt und Fachautor", Bio="Volker Weber hat einen Abschluss als Diplom-Wirtschaftsingenieur der Technischen Universität Darmstadt. Er ist als freiberuflicher Systemarchitekt und Fachautor tätig sowie ständiger Mitarbeiter von heise online und c't. Außerdem hat er Beiträge im Byte Magazine, in der Computerwoche, der NZZ und anderen Publikationen veröffentlicht." },
				new Speaker { Name = "Axel Kossel, Heise Zeitschriften Verlag", Bio="Axel Kossel arbeitet seit 1986 bei c't. 1994 übernahm er die Leitung des Ressorts Kommunikation, das mittlerweile Internet heißt. Zu seinen Themen gehört unter anderem die Nutzung sozialer Netzwerke mobil und am PC." },
				new Speaker { Name = "Joerg Heidrich, Heise Zeitschriften Verlag", Bio="Rechtsanwalt Joerg Heidrich, Fachanwalt für IT-Recht ist seit 2001 als Justiziar und Datenschutzbeauftragter des Heise Zeitschriften Verlags (c't, iX, Technology Review, heise online) und Rechtsanwalt für den Bereich der neuen Medien in Hannover tätig. Nach dem Studium der Rechtswissenschaften in Köln und Concord, NH, USA, beschäftigt er sich seit über fünfzehn Jahren mit den Problemen des Internet- und Medienrechts. Herr Heidrich ist Autor zahlreicher Fachbeiträge zu rechtlichen Aspekten der IT-Sicherheit sowie regelmäßig als Referent in diesem Bereich tätig. Seit 2007 ist er als Fachanwalt für IT-Recht zugelassen. Zudem ist er einer der Herausgeber der Loseblattsammlung Heise Online-Recht." },
				new Speaker { Name = "Alexander Kluge, Kluge Consulting GmbH", Bio="Alexander Kluge beschäftigt sich als Berater seit fast zwanzig Jahren mit den drei großen „K“: Kommunikation, Kooperation und Koordinierung von Geschäftsprozessen. Er gründete mit Kluge & Partner einen der er ersten Lotus Business Partner in Deutschland, wurde mehrfach in der LOTUS und später IBM Community ausgezeichnet. Heute begleitet Alexander Kluge Unternehmen an der Schnittstelle zwischen Organisationsentwicklung und IT auf ihrem Weg zum Enterprise 2.0 aka Social Business. Die Herausforderungen sind vergleichbar: Neue Wege der Kommunikation erproben, effiziente Kooperation in Team umsetzen und Geschäftsprozesse optimieren. Für die Transformation der Unternehmenskultur baut Kluge Consulting die Brücke zwischen IT und Management." },
				new Speaker { Name = "Martin Alexander Ogaza, Robert Bosch GmbH", Bio="Martin Ogaza ist Diplomkaufmann mit Schwerpunkt auf Organisationsentwicklung und Change Management. Als Projektleiter im Anwendungsfeld \"interne Zusammenarbeit\" entwickelt er bei der Robert Bosch GmbH Modelle und Strategien für die Verbesserung der Zusammenarbeit durch die Nutzung von Social Media. Sein Fokus liegt vor allem auf globalen Entwicklungsprojekten. In diesem Umfeld pilotiert Ogaza seine Arbeitsmodelle und misst den Einfluss von Social Business auf deren Effizienz und Effektivität, um anschließend die erfolgreichen Modelle und Strategien in der weltweiten Organisation zu verankern. Ogaza ist seit sechs Jahren bei Bosch tätig. Angefangen hat er in der zentralen Entwicklung. Danach übernahm er drei Jahre lang die Projektleitung für das Wissensmanagement bevor er in das Enterprise 2.0 Projekt wechselte." },
                //new Speaker { Name = "(tbd)", Bio="" },
				new Speaker { Name = "Prof. Dr. Thomas J. Schult, Professor an der Hochschule Hannover", Bio="Thomas J. Schult vertritt den Bereich \"Neue Medien\" im Studiengang Informationsmanagement der Hochschule Hannover. Seine Schwerpunkte in Lehre und Forschung bilden die Themen Content-Management-Systeme, Enterprise Social Networks und E-Learning. 2012/13 arbeitete er als Gastwissenschaftler an der University of California in Berkeley (USA). Nach seinem Studium der Informatik, Mathematik und Philosophie forschte er zunächst am Psychologischen Institut der Universität Freiburg und arbeitete danach in der c't-Redaktion, zuletzt als Ressortleiter. Seit er im Jahre 2001 auf die Professur berufen wurde, wirkt er auch freiberuflich als Journalist und Berater." },
			};
            this.Sessions = new List<Session>
			{
				new Session { Title = "Vernetzung jenseits der E-Mail", Speaker = this.Speakers[0], Description="E-Mail funktioniert, ist aber ineffizient – speziell in großen Verteilern und bei langen Mails. Alternativen wie Knowledge Management, Dateibibliotheken oder Sharepoint tun sich schwer. Doch Menschen wollen sich auch jenseits der E-Mail vernetzen. Das macht der Erfolg von Facebook, Microblogging & Co. deutlich. Die entscheidende Frage ist daher: wie macht das soziale Intranet das Unternehmen leistungsfähiger, wie kann es zum Unternehmenserfolg beitragen?"},
				new Session { Title = "Die Gehirne der Mitarbeiter im Intranet vernetzen", Speaker = this.Speakers[1], Description="Social Intranet muss mehr sein, als in Wikis und Timelines bestattetes Wissen. Richtig angewendet, knüpft die Technik lebendige Verbindungen zwischen Wissensträgern und Wissensnutzern im Unternehmen. Der Informationsfluss wird beschleunigt und überwindet Grenzen, wie sie zementierte E-Mail-Pfade ziehen. Damit das funktioniert, müssen aber vor allem die Wissensträger ins Boot geholt werden. Denn man kann niemand dazu zwingen, \"social\" zu denken und zu handeln. Hier müssen Technik und Mitarbeiterführung Hand in Hand arbeiten."},
				new Session { Title = "Social Intranet & Co. rechtssicher einsetzen", Speaker = this.Speakers[2], Description="Die Nutzung von Social Intranet- oder Collaboration-Tools im Unternehmen werfen immer auch juristische Probleme auf. Das fängt bei Fragen wie der nach dem Urheberrecht an verwendeten Bildern und Texten an. Problematisch ist auch die Frage nach der Überwachung der Tätigkeit von Mitarbeitern in diesen Netzwerken und die damit verbundenen datenschutzrechtlichen Probleme. Der Vortrag zeigt die entstehenden rechtlichen Probleme auf und bietet praktische und praxisnahe Lösungsmöglichkeiten dafür an."},
				new Session { Title = "Social Software kann man installieren – Social Business aber nicht", Speaker = this.Speakers[3], Description="Der Wandel des Unternehmens zum „Social Business“ gelingt nicht allein durch die Installation von Social Software. Experten sind sich einig, dass die Technik nur 20% des Erfolgs ausmachen. Die restlichen 80% resultieren aus dem Management des kulturellen Wandels. Dies ist einer der Gründe, warum Social Business-Projekte häufig scheitern."},
				new Session { Title = "Anwenderbericht: Social Business @ Bosch", Speaker = this.Speakers[4], Description="Im Rahmen des Projektes Enterprise 2.0 treibt die Robert Bosch GmbH den Einsatz von Tools und Verfahren für das Social Business voran. In seinem Vortrag zeigt Martin Ogaza auf, aus welchen Gründen sich Bosch mit dem Thema Social Business beschäftigt und welche Ziele das Unternehmen mit den Aktivitäten verfolgt. Basierend auf den Zielen erläutert Ogaza den Implementierungsansatz und geht dabei gezielt auf die folgenden Dimensionen ein: Guidelines & Principles, Technology & Process, Leadership & Enabling sowie Organization."},
                //new Session { Title = "Erfahrungen, Hindernisse und Lösungsansätze aus der Unternehmenspraxis", Speaker = this.Speakers[5], Description="Nähere Informationen folgen in Kürze!"},
				new Session { Title = "Werkzeuge fürs Social Intranet – ein Marktüberblick", Speaker = this.Speakers[5], Description="Viele Firmen-Intranets sind weit entfernt vom gewohnten Handling der sozialen Netzwerke. Mitarbeiter möchten unkompliziert ältere Dokumente finden, Arbeitsgruppen beitreten oder sogar gründen, synchron kommunizieren, Aktivitäten anderer verfolgen, indirekte Kontakte nutzen und gemeinsam an Dokumenten arbeiten. Auf diese Bedürfnisse geht eine wachsende Zahl von Produkten ein. Das an der Hochschule Hannover entwickelte Informationsangebot imBeruf.de versucht die verfügbaren Lösungen zu analysieren."},
			};
        }

        public static Repository Current
        {
            get
            {
                lock (_lockObject)
                {
                    if (_current == null)
                        _current = new Repository();
                    return _current;
                }
            }
        }

        private List<string> _topics;
        public List<string> Topics
        {
            get { return _topics; }
            set { _topics = value; this.OnPropertyChanged(); }
        }

        private List<AgendaEntry> _agenda;
        public List<AgendaEntry> Agenda
        {
            get { return _agenda; }
            set { _agenda = value; this.OnPropertyChanged(); }
        }

        private List<Speaker> _speakers;
        public List<Speaker> Speakers
        {
            get { return _speakers; }
            set { _speakers = value; this.OnPropertyChanged(); }
        }

        private List<Session> _sessions;
        public List<Session> Sessions
        {
            get { return _sessions; }
            set { _sessions = value; this.OnPropertyChanged(); }
        }
    }
}
