// Copyright (c) 2014 Oliver Lau <ola@ct.de>, Heise Zeitschriften Verlag
// All rights reserved.

#pragma warning ( disable : 4996 )

#include <iostream>

#include <boost/signals2.hpp>
#include <boost/variant.hpp>


/****************************************************************
 *
 * Beispiel 1
 *
 ****************************************************************/


class FooReceiver {
public:
  void operator()() const {
    std::cout << "Hallo, Foo!" << std::endl;
  }
};


class BarReceiver {
public:
  void operator()() const {
    std::cout << "Hallo, Bar!" << std::endl;
  }
};


void example1(void)
{
  typedef boost::signals2::signal<void()> signal_type;
  signal_type sig;
  
  FooReceiver foo;
  BarReceiver bar;

  sig.connect(foo);
  sig.connect(bar);

  sig();
}



/****************************************************************
 *
 * Beispiel 2
 *
 ****************************************************************/


class Summarizer {
public:
  void operator()(int a, int b) const {
    std::cout << a << " + " << b << " = " << (a+b) << std::endl;
  }
};


void example2(void)
{
  typedef boost::signals2::signal<void(int, int)> signal_type;
  signal_type sig;
  
  Summarizer foo;

  sig.connect(foo);

  sig(2, 3);
}



/****************************************************************
 *
 * Beispiel 3
 *
 ****************************************************************/


float mul(float a, float b) {
  float ab = a * b;
  std::cout << a << " * " << b << " = " << ab << std::endl;
  return ab;
};


void example3(void)
{
  typedef boost::signals2::signal<float(float, float)> signal_type;
  signal_type sig;

  sig.connect(&mul);

  std::cout << "Ergebnis: " << *sig(6.02214f, 1e23f) << std::endl;
}



/****************************************************************
 *
 * Beispiel 4
 *
 ****************************************************************/


class Cell 
{
  typedef boost::signals2::signal<void (float)> OnExcited;

public:
  typedef OnExcited::slot_type OnExcitedSlotType;
  boost::signals2::connection doOnExcited(const OnExcitedSlotType &slot);

  void excite(void);

private:
  OnExcited onExcited;
};


boost::signals2::connection Cell::doOnExcited(const OnExcitedSlotType &slot)
{
  return onExcited.connect(slot);
}


void Cell::excite(void)
{
  onExcited(0.81f);
}


void printIntensity(float intensity)
{
  std::cout << "Intensitt: " << intensity << std::endl;
}


void example4(void)
{
  Cell cell;
  cell.doOnExcited(&printIntensity);
  cell.excite();
}



/****************************************************************
 *
 * hier gehts los ...
 *
 ****************************************************************/


int main(int argc, char *argv[]) 
{
  (void)argc;
  (void)argv;

  example1();
  example2();
  example3();
  example4();

  return EXIT_SUCCESS;
}
