// Copyright (c) 2014-2015 Oliver Lau <ola@ct.de>, Heise Zeitschriften Verlag
// All rights reserved.

#include <iostream>
#include <string>
#include "Variant.h"
#include "PubSub.h"

class Sender : public Publisher {
public:
  Sender() { }
  void doSomething() {
    // ...
    broadcast(std::string("Sag Hallo!"));
  }
  void doSomethingElse() {
    // ...
    broadcast(std::string("Wave hands!"));
  }
};


class Receiver : public Subscriber {
public:
  Receiver(const char *name)
    : name(name)
  { }

  void update(const Variant &message, Publisher *sender = nullptr) {
    if (message.isNull() || !message.isString())
      return;
    const std::string &msg = message.toString();
    if (msg == "Sag Hallo!")
      std::cout << "Hallo, ich bin " << name << "." << std::endl;
    else
      std::cout << name << ": " << "Huh?" << std::endl;
  }

private:
  const char* name;
};



int main(int argc, char *argv[]) 
{
  Sender sender;
  Receiver a("A");
  Receiver b("B");
  Receiver c("C");

  sender.subscribe(&a);
  sender.subscribe(&b);
  sender.subscribe(&c);

  sender.doSomething();
  sender.doSomethingElse();

  return 0;
}
