#!/usr/bin/env python
# -*- coding: utf-8 -*-		Script-Coding auf UTF-8 setzen (Umlaute-Fix)

#### Dieses Python-Programm steuert auf GPIO Eingang einen Musikplayer fr bestimmte Zeit ein.
#### Die GPIO Software WiringPi, sowie MPD, MusicPlayer-Daemon.
#### MPD wird mit MPC, MusicPlayer-Control, gesteuert, welches im MPD-Packet enthalten ist.
#### Geschrieben von Mathias Sonderfeld in Python 2.7.3 auf Rasbian Wheezy fr den Raspberry Pi.

#Initialisierung

import time								# Zeit-Library
print time.strftime("%d.%m.%Y %H:%M:%S") + " - beginne Intitialisierung, lade Bibliotheken..."
import RPi.GPIO as gpio					# GPIO Library
import os as bash						# Shell-Library
gpio.setmode(gpio.BOARD)				# den GPIO Board Modus whlen (Pin-Zahlen entsprechen Board-Beschriftung)

# Pins der Stiftleiste in Variablen ablegen
print time.strftime("%d.%m.%Y %H:%M:%S") + " - Intitialisierung luft, lade Variablen..."
tkrelais		= 7						# Eingang fr Startsignal, 
betriebsled 	= 22					# Kontroll-LED rot	
aktivled		= 18					# Kontroll-LED grn
fs20ein			= 16					# steuert FS20-Modul an
fs20aus			= 15

#MPD Variablen
wiedergabeliste	= "total"
shuffle		= True
crossfade	= 5
lautstaerke	= 75
fadeinzeit	= 10
fadeoutzeit	= 10

#Systemvariablen
nachlaufzeit 	= 7

#Funktionen definieren
print time.strftime("%d.%m.%Y %H:%M:%S") + " - Initialisierung luft, definiere Funktionen..."
def einaus( pin, wartezeit ):
	gpio.output(pin, 1)
	time.sleep(wartezeit/2.0)
	gpio.output(pin, 0)
	time.sleep(wartezeit/2.0)
	return

#GPIO Pins kalibirieren und resetten
print time.strftime("%d.%m.%Y %H:%M:%S") + " - Initialisierung luft, kalibriere GPIO..."
gpio.setup(tkrelais, gpio.IN, pull_up_down=gpio.PUD_DOWN)
gpio.setup(betriebsled, gpio.OUT)
gpio.setup(aktivled, gpio.OUT)
gpio.setup(fs20ein, gpio.OUT)
gpio.setup(fs20aus, gpio.OUT)
gpio.output(betriebsled, 0)
gpio.output(aktivled, 0)
gpio.output(fs20ein, 0)
gpio.output(fs20aus, 0)

#MPD einrichten
print time.strftime("%d.%m.%Y %H:%M:%S") + " - Initialisierung, Zusatz-Programme werden gestartet..."
bash.system("mpc -q stop")
bash.system("mpc -q clear")
bash.system("mpc -q volume -100")
bash.system("mpc -q crossfade " + str(crossfade))
bash.system("mpc -q load " + wiedergabeliste + " > /dev/null")
if shuffle == True:
	bash.system("mpc -q shuffle")
	print time.strftime("%d.%m.%Y %H:%M:%S") + " - Initialisierung, MPD Playlist geshuffelt"

# Betrieb
gpio.output(betriebsled, 1)
print time.strftime("%d.%m.%Y %H:%M:%S") + " - Intitialisierung abgeschlossen, einsatzbereit"

try:
	while(True):
		# Eingabe abwarten
		print time.strftime("%d.%m.%Y %H:%M:%S") + " - Warte auf Eingabe"
		while(not gpio.input(tkrelais)):
			time.sleep(5)
		print time.strftime("%d.%m.%Y %H:%M:%S") + " - Eingabe erkannt, beginne Wiedergabe"

		#Anlage einschalten
		einaus(fs20ein, 0.4)
		print time.strftime("%d.%m.%Y %H:%M:%S") + " - Anlage eingeschaltet"

		#Wiedergabe starten
		bash.system("mpc -q play")
		print time.strftime("%d.%m.%Y %H:%M:%S") + " - Wiedergabe gestartet"
		#Startzeit sichern
		startzeit=time.time()
		
		#Laufzeit berechnen
		minuten= int(time.strftime("%M")) - nachlaufzeit
		if minuten <= 30:
			laufzeit=((30-minuten)*60)+int(time.strftime("%S"))
		else:
			laufzeit=((60-minuten)*60)+int(time.strftime("%S"))

                #Fade In
                fadein=1
                while(fadein <= 100):
                        bash.system("mpc -q volume " + str(lautstaerke*fadein/100))
                        einaus(aktivled, fadeinzeit / 100.0)
                        fadein=fadein+1
                print time.strftime("%d.%m.%Y %H:%M:%S") + " - Fade In abgeschlossen. Warte auf Relais-Freigabe..."

		#Auf Relaisfreigabe warten
		while(gpio.input(tkrelais)):
			einaus(aktivled, 1)
                print time.strftime("%d.%m.%Y %H:%M:%S") + " - Relais frei, restliche Laufzeit in Bereitschaft"
		
		# Laufzeit abwarten
		gpio.output(aktivled,1)
		laufzeit=(laufzeit - int( time.time()- startzeit) - fadeoutzeit)
		while( laufzeit > 0):
			if gpio.input(tkrelais) == 1:
				laufzeit=0
			else:
				time.sleep(1)
			laufzeit=laufzeit-1
                print time.strftime("%d.%m.%Y %H:%M:%S") + " - Fading Out..."

		#Fade Out
		fadeout=100
		while(fadeout > 0):
			bash.system("mpc -q volume " + str(lautstaerke*fadeout/100))
                        einaus(aktivled, fadeoutzeit / 100.0)
			fadeout=fadeout-1
                print time.strftime("%d.%m.%Y %H:%M:%S") + " - Fade Out abgeschlossen. Warte auf Relais-Freigabe..."
		
		#Musik und Anlage ausschalten
		bash.system("mpc -q stop")
		einaus(fs20aus,0.4)

		#Auf Relaisfreigabe warten
              	while(gpio.input(tkrelais)):
                        einaus(aktivled, 1)
      		print time.strftime("%d.%m.%Y %H:%M:%S") + " - Relais frei, Durchlauf abgeschlossen, lsche Variablen."
		

		#Variablen lschen
		startzeit=False
		minuten=False
		laufzeit=False
		fadeout=False

except KeyboardInterrupt:
	gpio.cleanup()
	bash.system("mpc -q stop")
