/*****************/
/* 28.06.2015    */
/* Kai-Uwe Mrkor */
/*****************/

#include <pebble.h>
#include <string.h>

  
 
// In pebble-js-app.js muss in Pebble.addEventListener
// die URL abgelegt werden, unter der die eigene Konfigurationsseite
// erreichbar ist !

// Der in der Konfiguration übergebene Text ist aus Platzgründen nicht
// persistent. Daher geht er beim Verlassen der App verloren!  
  
  
static Window *window;
static ScrollLayer *scroll_layer;
static TextLayer *spickertext_layer,  *time_layer;
static bool uhrzeitAnzeigen = true;



#define SPICKER_TEXT  0



//
// Uhren-Event
//
static void tick_handler(struct tm *tick_time, TimeUnits units_changed) {

  // Puffer zur Ablage der Uhrzeit erzeugen
  static char buffer[] = "00:00";

  // Uhrzeit ausgeben
  strftime(buffer, sizeof("00:00"), "%H:%M", tick_time);
  text_layer_set_text(time_layer, buffer);        
}



//
// Event der Select-Taste
// Umschaltung zwischen Anzeige der Uhrzeit und dem Text des "Spickers"
//
static void select_click_handler(ClickRecognizerRef recognizer, void *context) {  
    
  
  if (uhrzeitAnzeigen){
    
      // Anzeige der Uhrzeit wird beendet
      // Spickertest wird angezeigt    
      layer_set_hidden((Layer *)time_layer, true);    
      layer_set_hidden((Layer *)spickertext_layer, false);        
    
      uhrzeitAnzeigen = false;
  }
  else {
    
      // Anzeige des Spickers wird beendet
      // Uhrzeit wird angezeigt
      layer_set_hidden((Layer *)time_layer, false);
      layer_set_hidden((Layer *)spickertext_layer, true);    
      
      uhrzeitAnzeigen = true;
 } 
}



//
// Tastendruck nach oben (Spickertext nach oben scrollen)
//
static void up_click_handler(ClickRecognizerRef recognizer, void *context) {
  
   if (!uhrzeitAnzeigen){
     GPoint offset = scroll_layer_get_content_offset(scroll_layer);
     offset.y = offset.y + 50;
     scroll_layer_set_content_offset	(scroll_layer, offset, false);
   }
}



//
// Tastendruck nach unten (Spickertext nach unten scrollen)
//
static void down_click_handler(ClickRecognizerRef recognizer, void *context) {

  if (!uhrzeitAnzeigen){
     GPoint offset = scroll_layer_get_content_offset(scroll_layer);
     offset.y = offset.y - 50;
     scroll_layer_set_content_offset	(scroll_layer, offset, false);
  }
}



//
// Einrichtung der Event-Handler für die drei rechten Tasten
//
static void click_config_provider(void *context) {
  
  window_single_click_subscribe(BUTTON_ID_SELECT, select_click_handler);
  window_single_click_subscribe(BUTTON_ID_UP, up_click_handler);
  window_single_click_subscribe(BUTTON_ID_DOWN, down_click_handler);
}



//
// Handler für eingehende Nachrichten
//
void in_recv_handler(DictionaryIterator *iterator, void *context)
{
  app_log(APP_LOG_LEVEL_DEBUG, "main.c", 0, "###in_recv_handler:  Aufgerufen ###");
  
  
  Tuple *textTuple = dict_find(iterator, SPICKER_TEXT);
  if (textTuple) {
    app_log(APP_LOG_LEVEL_DEBUG, "main.c", 0, "###in_recv_handler: text %s ###",  textTuple->value->cstring);
    text_layer_set_text(spickertext_layer, textTuple->value->cstring);
  } 
}



//
//
//
static void window_load(Window *window) {
    
  Layer *window_layer = window_get_root_layer(window);
  GRect bounds = layer_get_bounds(window_layer);
  const GRect max_text_bounds = GRect(0, 0, bounds.size.w, 20000); // 20000 pixels of text
  

  // ------------------
  // --  Uhrzeit     --
  // ------------------
  
  // Text-Layer für die Uhrzeit
  time_layer = text_layer_create(GRect(0, 55, bounds.size.w, 50));  
  text_layer_set_background_color(time_layer, GColorWhite);
  text_layer_set_text_color(time_layer, GColorBlack);

  // Schriftart und Ausrichtung der Uhrzeit einrichten
  text_layer_set_font(time_layer, fonts_get_system_font( FONT_KEY_ROBOTO_BOLD_SUBSET_49));  //   FONT_KEY_BITHAM_42_BOLD
  text_layer_set_text_alignment(time_layer, GTextAlignmentCenter);

  // Kindfenster zufügen 
  layer_add_child(window_get_root_layer(window), text_layer_get_layer(time_layer));
  
  
  
  
  // ------------------
  // -- Spicker-Text --
  // ------------------  
  
  scroll_layer = scroll_layer_create( bounds);  
  scroll_layer_set_content_size( scroll_layer,  max_text_bounds.size);
  
  // Text-Layer erzeugen 
  spickertext_layer = text_layer_create( max_text_bounds);  
  text_layer_set_font(spickertext_layer, fonts_get_system_font( FONT_KEY_GOTHIC_24_BOLD));
  
  // spickertext_layer zum scroll_layer zufügen  
  scroll_layer_add_child( (ScrollLayer *)scroll_layer, text_layer_get_layer(spickertext_layer) );
  
  // Kindfenster zufügen 
  layer_add_child(window_get_root_layer(window), scroll_layer_get_layer(scroll_layer));  
  
  // Der Spickertext wird erst einmal ausgeblendet
  layer_set_hidden((Layer *)spickertext_layer, true);  

  
  // Zuordnung der Tasten
  window_set_click_config_provider(window, (ClickConfigProvider)click_config_provider);

  // Initialen Text festlegen
  text_layer_set_text(spickertext_layer, "Den eigenen Text bitte in der Pebble-App eintragen!");
}



//
// Fenster abbauen
//
static void window_unload(Window *window) {
  scroll_layer_destroy(scroll_layer);
  text_layer_destroy(time_layer);
  text_layer_destroy(spickertext_layer);
}



//
// Initialisierung aller Komponenten
//
static void init(void) {
  
  // Fenster 
  window = window_create();
  window_set_fullscreen(window, true);  
  
  // Handler für das Einrichten und Abbauen des Fensters festlegen
  window_set_window_handlers(window, (WindowHandlers) {
	  .load = window_load,
    .unload = window_unload,
  });
    
   
  // Handler für eingehende Nachrichten anmelden 
  app_message_register_inbox_received((AppMessageInboxReceived) in_recv_handler);
  app_message_open(app_message_inbox_size_maximum(), 0);
  
  
  // Tick-Timer anmelden (löst jede Sekunde ein Event aus)
  tick_timer_service_subscribe(SECOND_UNIT, tick_handler);
   
  
  // 
  const bool animated = true;
  window_stack_push(window, animated);
  
}



//
// Fenster wieder abbauen
//
static void deinit(void) {
  
  window_destroy(window);
}



//
// Das Hauptprogramm
//
int main(void) {
  init();
  app_event_loop();
  deinit();
}
