# Wsus installieren
Install-WindowsFeature -Name UpdateServices -IncludeManagementTools
# Basisinstallation anstoen
sl "C:\Program Files\Update Services\Tools"
.\wsusutil.exe postinstall CONTENT_DIR=c:\wsus
# Konfiguration auslesen
$wsus=Get-WSUSServer
$wsusConfig=$wsus.GetConfiguration()
# Updates bei Microsoft abholen
Set-WsusServerSynchronization -SyncFromMU
# Sprache einstellen
$wsusConfig.AllUpdateLanguagesEnabled=$false
$wsusConfig.SetEnabledUpdateLanguages("de")
# Updates nicht lokal vorhalten
$wsusConfig.HostBinariesOnMicrosoftUpdate=$true
# Config setzen
$wsusConfig.Save()
# Kategorien holen
$subscription=$wsus.GetSubscription()
$subscription.StartSynchronizationForCategoryOnly()
# Ende des Vorgangs abwarten
Write-Host "Syncing categories " -NoNewline
While ($subscription.GetSynchronizationStatus() -ne 'NotProcessing') {
	Write-Host "." -NoNewline
	Start-Sleep -Seconds 15
}
Write-Host " done."
# Produktauswahl zurcksetzen
get-WsusProduct | Set-WsusProduct -disable
# Produkte auswhlen
Get-WsusProduct | Where-Object { 
	$_.Product.Title -match ('Windows 10') -or 
	$_.Product.Title -match ('Windows Defender') -or 
	$_.Product.Title -match ('Security Essentials')
} | Set-WsusProduct
# Kategorien auswhlen, Filtern hier wenig sinnvoll
#Get-WsusClassification | Where-Object { $_.Classification.Title -in (
#	'Sicherheitsupdates', 
#	'Wichtige Updates',
#	'Definitionsupdates',
#	'Update-Rollups'
#) } | Set-WsusClassification
Get-WsusClassification | Set-WsusClassification
# Zeitplan aufstellen
$subscription.SynchronizeAutomatically=$false
# Mitternacht
#$subscription.SynchronizeAutomaticallyTimeOfDay= (New-TimeSpan -Hours 0)
# Einmal am Tag
#$subscription.NumberOfSynchronizationsPerDay=1
# Speichern
$subscription.Save()
# von Hand anstoen
$subscription.StartSynchronization()
# Ende des Vorgangs abwarten
Write-Host "Syncing products " -NoNewline
While ($subscription.GetSynchronizationStatus() -ne 'NotProcessing') {
	Write-Host "." -NoNewline
	Start-Sleep -Seconds 15
}
Write-Host " done."
# Assistent beim ersten Aufruf der mmc bergehen
$wsusConfig.OobeInitialized=$true
# Config setzen
$wsusConfig.Save()


