package de.jockels.forcetouchemu;

import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;

/**
 * Created by jwirt on 19.01.2016.
 *
 * onTouchListener, der ForceClicks erkennt und dann onForceClick auslöst.
 *
 * Weil er dazu intern onClick- und onLongClick-Listener der View umbiegen muss, erlaubt
 * die Implementierung eigene Listener, die er dann aufruft.
 *
 * Problem: Wenn man nach einem ForceClick den Finger auf dem Display lässt, wird
 * View.performLongClick ausgelöst, was wiederum Accessibility- und SystemSound-
 * Aufrufe nach sich zieht. Nur der onLongClick wird unterdrückt.
 *
 */
public abstract class OnForceTouchListener implements View.OnTouchListener, View.OnClickListener, View.OnLongClickListener {
    boolean mFiredForceClick, mFiredLongClick;
    View.OnClickListener mClick;
    View.OnLongClickListener mLong;

    public abstract boolean onForceClick(View view, MotionEvent ev);

    public boolean performForceClick(View view, MotionEvent ev) {
        mFiredForceClick = true;
        return onForceClick(view, ev);
    }

    @Override
    public boolean onTouch(View view, MotionEvent ev) {

        if (ev.getAction() == MotionEvent.ACTION_DOWN) {
            mFiredForceClick = false;
            mFiredLongClick = false;
            if (mLong==null) mLong = new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View view) {
                    if (!mFiredForceClick) OnForceTouchListener.this.onLongClick(view);
                    mFiredLongClick = true;
                    return true;
                }
            };
            if (mClick==null) mClick = new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (!mFiredForceClick) OnForceTouchListener.this.onClick(view);
                }
            };
            view.setOnClickListener(mClick);
            view.setOnLongClickListener(mLong);
        }

        if (ForceTouchHelper.isForceTouch(ev) && !mFiredForceClick && !mFiredLongClick)
            return performForceClick(view, ev);

        return false;
    }
}
