#!/bin/bash
# configure nfs on controller
ssh oslcontroller <<EOF
yum -y install nfs-utils
systemctl enable rpcbind
systemctl enable nfs-server
cat <<END >> /etc/exports
/srv/node/nova-nfs osl*mem(rw,no_root_squash)
/srv/node/cinder-nfs osl*mem(rw,no_root_squash)
END
for n in nova cinder; do
  mkdir -p /srv/node/\$n-nfs
  chmod 755 /srv/node/\$n-nfs
  chown \$n.\$n /srv/node/\$n-nfs
done
systemctl restart rpcbind
systemctl restart nfs-server
showmount -e
EOF
