package com.linkesoft.relax;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.v17.leanback.app.BrowseFragment;
import android.support.v17.leanback.widget.ArrayObjectAdapter;
import android.support.v17.leanback.widget.BaseCardView;
import android.support.v17.leanback.widget.HeaderItem;
import android.support.v17.leanback.widget.ImageCardView;
import android.support.v17.leanback.widget.ListRow;
import android.support.v17.leanback.widget.ListRowPresenter;
import android.support.v17.leanback.widget.OnItemViewClickedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.RowPresenter;
import android.view.ViewGroup;
import android.widget.Toast;

public class MainFragment extends BrowseFragment implements OnItemViewClickedListener {

    public MainFragment() {
        // leerer Constructor für Fragment
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        // zeige Badge auf der Übersichtsseite oben rechts
        setBadgeDrawable(getResources().getDrawable(R.drawable.badge,null));
        // Adapter für die einzelnen Zeilen
        ArrayObjectAdapter rowsAdapter = new ArrayObjectAdapter(new ListRowPresenter());
        // Schleife über Video-Sektionen
        for(Videos.VideoSection section : Videos.sections) {
            // Adapter für Videos in einer Zeile
            ArrayObjectAdapter rowAdapter = new ArrayObjectAdapter(
                    new CardPresenter());
            for(Videos.Video video : section.videos) {
                rowAdapter.add(video);
            }
            // Titel der Sektion und Adapter für Videos
            rowsAdapter.add(new ListRow(new HeaderItem(section.title), rowAdapter));
        }
        setAdapter(rowsAdapter);
        // Klick auf ein ausgewähltes Video
        setOnItemViewClickedListener(this);
    }

	@Override
	public void onItemClicked(Presenter.ViewHolder itemViewHolder, Object item, RowPresenter.ViewHolder rowViewHolder, Row row) {
		Videos.Video video = (Videos.Video)item;
		if(video instanceof Videos.YouTubeVideo) {
			// starte YouTube App via Intent
		   Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse("vnd.youtube:" + video.id));
			PackageManager packageManager = getActivity().getPackageManager();
			if (intent.resolveActivity(packageManager) != null) {
				startActivity(intent);
			} else {
				// YouTube App nicht gefunden
				Toast.makeText(getActivity(),"Bitte installieren Sie die YouTube App aus dem Play Store um dieses Video anschauen zu können.", Toast.LENGTH_LONG).show();
			}
		} else {
			Intent i = new Intent(getActivity(),VideoActivity.class);
			i.putExtra(VideoActivity.ID,video.id);
			getActivity().startActivity(i);
		}


	}

	// Presenter für die Video-Karten
    private class CardPresenter extends Presenter {

		@Override
        public ViewHolder onCreateViewHolder(ViewGroup parent) {
            // verwende vorgefertigten ImageCardView
            ImageCardView cardView = new ImageCardView(parent.getContext());
            // und verpacke ihn in einen ViewHolder für's Recycling
            return new ViewHolder(cardView);
        }

        @Override
        public void onBindViewHolder(ViewHolder viewHolder, Object item) {
            // fülle ImageCardView mit Daten des Videos
            Videos.Video video = (Videos.Video)item;
            ImageCardView cardView = (ImageCardView)viewHolder.view;
            cardView.setTitleText(video.title);
            cardView.setContentText(video.subtitle);
            cardView.setMainImage(getResources().getDrawable(video.thumbnailDrawableId,null));
            cardView.setMainImageDimensions(300,200); // Größe des Bildes (bestimmt Größe der Kachel)
            // zeige immer Titel/Untertitel, selbst wenn Fokus auf Kategorien ist
            cardView.setInfoVisibility(BaseCardView.CARD_REGION_VISIBLE_ALWAYS);
        }

        @Override
        public void onUnbindViewHolder(ViewHolder viewHolder) {
            // Speicher/Resourcen freigeben
            ImageCardView cardView = (ImageCardView) viewHolder.view;
            cardView.setMainImage(null);
        }
    }
}
