package com.linkesoft.relax;

/**
 * Sammlung von lokalen Videos (in res/raw) und YouTube-Videos
 */
public class Videos {
    static VideoSection sections[] = {
            new VideoSection("Feuer",new Video[] {
                    new LocalVideo(R.raw.fire1,R.drawable.fire1,"Flammen"),
                    new YouTubeVideo("EIBOAXbHz6s",R.drawable.fire2,"Kaminfeuer 1"),
                    new YouTubeVideo("qh6RaVqbo4Y",R.drawable.fire3,"Kaminfeuer 2"),
                    new YouTubeVideo("eyU3bRy2x44",R.drawable.fire4,"Kaminfeuer 3"),
            }),
            new VideoSection("Wasser",new Video[] {
                    new LocalVideo(R.raw.water1,R.drawable.water1,"Quallen"),
					new YouTubeVideo("K1xSGYzWWBg",R.drawable.water2,"Zierfische"),
					new YouTubeVideo("cYU_dhrmvyU",R.drawable.water3,"Künstl. Aquarium"),
            })
    };

    public static class VideoSection {
        String title;
        Video[] videos;
        private VideoSection(String title,Video[] videos) {
            this.title=title;
            this.videos=videos;
        }
    }

	/**
	 * Basisklasse für Videos
	 */
    public static abstract class Video {
        String id;
        String title;
        String subtitle;
        int thumbnailDrawableId;
        private Video(String id,int thumbnailDrawableId,String title,String subtitle) {
            this.id=id;
            this.thumbnailDrawableId=thumbnailDrawableId;
            this.title=title;
            this.subtitle=subtitle;
        }
    }

    /**
     * YouTube-Video (id ist YouTube-ID)
     */
    public static class YouTubeVideo extends Video {
        public YouTubeVideo(String id,int thumbnailDrawableId,String title) {
            super(id,thumbnailDrawableId,title,"YouTube-Video");
        }
    }

    /**
     * lokales Video (id ist Ressource-ID R.raw.<id>)
     */
    public static class LocalVideo extends Video {
        public LocalVideo(int id,int thumbnailDrawableId,String title) {
            super(String.valueOf(id),thumbnailDrawableId,title,"Lokales Video");
        }
    }

}
