#!/bin/bash

# zenity --info --text "Hello world"

# Desktop aufraeumen
rm -f ~/Desktop/Report_an_error.desktop ~/Desktop/tails-documentation.desktop
[[ -e ~/Desktop/Persistent ]] || ln -s ~/Persistent ~/Desktop/Persistent


# set desktop background
gsettings set org.gnome.desktop.background picture-uri 'file:///usr/share/images/desktop-base/joy.xml'

# delayed for 10s
(
    sleep 10;
    ## check and set German settings
    status=$(gsettings get org.gnome.desktop.input-sources sources)
    if { ! echo $status | grep -q ", 'de+nodeadkeys'"; }; then
	echo "export LC_ALL=de_DE.UTF-8" >> ~/.bashrc
	echo "export LANG=de_DE.UTF-8" >> ~/.bashrc
	gsettings set org.gnome.desktop.input-sources sources "[('xkb', 'de'),('xkb', 'us')]"
	gsettings set org.gnome.desktop.input-sources current 0
	ibus restart
	notify-send "Language settings" "Changed to German"
    fi
    ## configure terminal
    dconf load '/org/gnome/terminal/' <<EOF
[legacy]
dark-theme=true
schema-version=uint32 3

[legacy/profiles:]
list=['ac9111ca-f309-4c49-9201-dfa8073b8925', '8ee0cf1e-9030-4627-a48e-cde911f4b605', '11140da1-5ab6-4811-bdae-446b78fe851b']
default='ac9111ca-f309-4c49-9201-dfa8073b8925'

[legacy/profiles:/:ac9111ca-f309-4c49-9201-dfa8073b8925]
default-size-columns=132
default-size-rows=42
use-system-font=false
visible-name='ju'
font='Monospace 14'
EOF

    # set hotkey <Super>t for terminal
    gsettings set org.gnome.settings-daemon.plugins.media-keys custom-keybindings "['/org/gnome/settings-daemon/plugins/media-keys/custom-keybindings/custom0/']"
    gsettings set org.gnome.settings-daemon.plugins.media-keys.custom-keybinding:/org/gnome/settings-daemon/plugins/media-keys/custom-keybindings/custom0/ name 'terminal'
    gsettings set org.gnome.settings-daemon.plugins.media-keys.custom-keybinding:/org/gnome/settings-daemon/plugins/media-keys/custom-keybindings/custom0/ command 'x-terminal-emulator'
    gsettings set org.gnome.settings-daemon.plugins.media-keys.custom-keybinding:/org/gnome/settings-daemon/plugins/media-keys/custom-keybindings/custom0/ binding '<Super>t'

) &


# wait for Tor to be ready
# while [[ ! `torsocks curl --connect-timeout 3 --retry 5 https://tails.boum.org 2>/dev/null` ]]; do sleep 1; done

#zenity --info --text "Tor is ready now"

notify-send "Autostart" "user settings applied"


