#Legt fest, dass diese Date für Varnish 4.0 oder hoeher geschrieben wurde.
vcl 4.0;

#Das Standard-Backend, auf das Varnish zurueckgreift.
backend default {
	.host = "127.0.0.1";
	.port = "8080";
}

#Mit der ACL werden Zugriffe auf das Purge-Kommando limitiert.
acl Purge {
	"127.0.0.1";
}

#Dieser sub-Abschnitt legt den Umgang mit Anfragen vor dem Abruf des Cache.
#fest
sub vcl_recv {
	#Wenn Varnish diese Anfrage zum ersten Mal verarbeitet, wird der Header
	#X-Forwarded-For um die IP des anfragenden Clients erweitert.
	if (req.restarts == 0) {
		if (req.http.x-forwarded-for) {
			set req.http.X-Forwarded-For = req.http.X-Forwarded-For + ", " + client.ip;
		} else {
			set req.http.X-Forwarded-For = client.ip;
		}
	}
	
	#Bei einer Purge- oder Domainpurge-Anfrage ueberprueft Varnish ob die
	#anfragende IP in der ACL Purge enthalten ist. Ist dem nicht so, wird
	#ein Fehlercode zurueckgegeben.
	if (req.method == "PURGE" || req.method == "DOMAINPURGE") {
		if (!client.ip ~ Purge) {
			return(synth(405));
		}
		return (purge);
	}

	#Varnish cacht ueblicherweise keine Anfragen die Cookies enthalten. Mit
	#dem nachfolgenden RegEx werden alle Cookies die mit _ beginnen oder
	#has_js enthalten entfernt. Diese werden nur von Trackingdiensten wie
	#Google Analytics gesetzt und sind fuer den Webserver nicht von belang.
	if (req.http.Cookie) {
		set req.http.Cookie = regsuball(req.http.Cookie, "(^|;\s*)(_[_a-z]+|has_js)=[^;]*", "");
	}
	
	#Varnish braucht statische, grosse Dateien nicht zu cachen.
	if (req.url ~ "\.(mp3|pdf|tif|tiff)(\?.*|)$") {
		return(pass);
	}
}

sub vcl_backend_response {
	#Pauschal werden Objekte fuer 5min gecacht.
	set beresp.ttl = 5m;

	#CSS und JS-Dateien fuer einen Tag.
	if (bereq.url ~ "\.(js|css)(\?.*|)$") {
		set beresp.ttl = 1d;
	}
}

sub vcl_deliver {

	#Wenn Varnish eine Anfrage aus dem Cache beantworten konnte setzt es
	#den Header X-Cache auf HIT, falls nicht auf MISS. So laesst sich
	#leicht ueberpruefen ob Varnish auch wirklich funktioniert.
	if (obj.hits > 0) {
		set resp.http.X-Cache = "HIT";
	} else {
		set resp.http.X-Cache = "MISS";
	}
}

