﻿<#
.SYNOPSIS
Trennt das virtuelle Laufwerk aus der in den ersten Zeilen des Skripts 
angegebenen VHD-Datei vom System und wartet anschließend, bis es per 
Dropbox synchronisiert wurde.

.NOTES
Copyright © 2017 Heise Medien GmbH & Co. KG / c't
Geschrieben von Hajo Schulz hos@ct.de

.LINK
https://ct.de/ypwx
#>

#---------- Hier an eigene Bedürfnisse anpassen ----------
$DropboxPath = $env:UserProfile + "\Dropbox"
$VhdPath = $DropboxPath + "\Dropbox.vhd"
$Action = 0 # Nichts tun = 0, Herunterfahren = 1, Energie sparen = 2, Abmelden = 3
#----------------- Ende der Anpassungen ------------------

# Haben wir Admin-Rechte? Wenn nicht, mit RunAs neu starten
$identity = [System.Security.Principal.WindowsIdentity]::GetCurrent()
$princ = New-Object System.Security.Principal.WindowsPrincipal($identity)
if(-not $princ.IsInRole([System.Security.Principal.WindowsBuiltInRole]::Administrator)) {
    Start-Process "$psHome\powershell.exe" -Verb RunAs -ArgumentList $MyInvocation.MyCommand.Path
    exit
}

# C#-Klasse zur Abfrage des Dropbox-Clients
$source = @"
using System;
using System.Diagnostics;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;

// .NET-Portierung des Python-Skripts unter http://www.dropboxwiki.com/dropbox-addons/python-script-to-get-file-or-folder-status-in-windows
public class Dropbox
{
  [DllImport("kernel32.dll", SetLastError = true)]
  static extern bool CallNamedPipe(string lpNamedPipeName,
    byte[] lpInBuffer, uint nInBufferSize,
    [Out] byte[] lpOutBuffer, uint nOutBufferSize,
    out uint lpBytesRead, uint nTimeOut);

  static byte[] CallNamedPipe(string pipeName, byte[] data, uint outBufSize, uint timeout)
  {
    byte[] outBuf = new byte[outBufSize];
    uint read;
    if (CallNamedPipe(pipeName, data, (uint)data.Length, outBuf, outBufSize, out read, timeout))
      return outBuf.Take((int)read).ToArray();
    return null;
  }

  [StructLayout(LayoutKind.Sequential)]
  struct DropboxRequest
  {
    public UInt32 magic;
    public UInt32 procId;
    public UInt32 threadId;
    public UInt32 requestType;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 524)]
    public byte[] path;

    public byte[] GetBytes()
    {
      int len = Marshal.SizeOf(this);
      byte[] bytes = new byte[len];
      IntPtr ptr = Marshal.AllocHGlobal(len);
      Marshal.StructureToPtr(this, ptr, true);
      Marshal.Copy(ptr, bytes, 0, len);
      Marshal.FreeHGlobal(ptr);
      return bytes;
    }
  }

  public static int GetStatus(string path)
  {
    Process proc = Process.GetCurrentProcess();
    int threadId = Thread.CurrentThread.ManagedThreadId;
    string pipeName = string.Format(@"\\.\PIPE\DropboxPipe_{0:d}", proc.SessionId);
    DropboxRequest request = new DropboxRequest {
      magic = 0x3048302,
      procId = (UInt32)proc.Id,
      threadId = (UInt32)threadId,
      requestType = 1,
      path = new byte[524]
    };
    for (int i = 0; i < request.path.Length; ++i)
      request.path[i] = 0;
    byte[] pathBytes = Encoding.Unicode.GetBytes(path);
    Array.Copy(pathBytes, request.path, Math.Min(pathBytes.Length, 524));
    byte[] answer;
    try {
      answer = CallNamedPipe(pipeName, request.GetBytes(), 16382, 1000);
    }
    catch (Exception) {
      return -1;
    }
    if (answer == null)
      return -1;
    string strAnswer = Encoding.Unicode.GetString(answer, 4, answer.Length - 4);
    int result;
    if (int.TryParse(strAnswer, out result))
      return result;
    return -1;
  }
}
"@
Add-Type -TypeDefinition $source

# VHD auswerfen und einen Moment warten, damit der Dropbox-Client das mitkriegt
$vhd = Get-DiskImage $VhdPath
if($vhd.Attached) {
    $vhd | Dismount-DiskImage
    Start-Sleep -Milliseconds 500
}

# Warten, bis der Dropbox-Client alles synchronisiert hat
$status = [Dropbox]::GetStatus($DropboxPath)
if($status -eq 2) { # Synchronising
    "Warte auf Dropbox ..."
    do {
        Start-Sleep -Milliseconds 500
        $status = [Dropbox]::GetStatus($DropboxPath)
    } while($status -eq 2)
}
"Alles synchronisiert."

switch($Action) {
    1 {
        "Rechner ausschalten ..."
        Stop-Computer
        exit
        break
    }
    2 {
        "Energiesparmodus ..."
        Add-Type -AssemblyName System.Windows.Forms
        [System.Windows.Forms.Application]::SetSuspendState("Suspend", $false, $false)
        exit
        break
    }
    3 {
        "Abmeldung ..."
        shutdown.exe /l
        exit
        break
    }
}
