/*
 * Decompiled with CFR 0.152.
 */
package infchem.realrobots.scratch;

import infchem.realrobots.config.ConfigHandler;
import infchem.realrobots.scratch.ScratchMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class ScratchIO {
    private static final int SCRATCH_PORT = 42001;
    private static final int NUM_BYTES_SIZE = 4;
    private Socket scratchSocket;
    private InputStream in = null;
    private OutputStream out = null;

    public ScratchIO() {
        try {
            this.scratchSocket = new Socket(ConfigHandler.scratchIP, 42001);
            this.in = this.scratchSocket.getInputStream();
            this.out = this.scratchSocket.getOutputStream();
        }
        catch (UnknownHostException e) {
            System.err.println("Scratch port (42001) not found");
        }
        catch (IOException e) {
            System.err.println("Scratch IO link could not be created");
        }
    }

    public void closeDown() {
        Object in = null;
        Object out = null;
        try {
            this.scratchSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean broadcastMsg(String msg) {
        String scratchMsg = "broadcast \"" + msg + "\"";
        return this.sendMsg(scratchMsg);
    }

    public boolean updateMsg(String name, String value) {
        String scratchMsg = "sensor-update " + name + " " + value;
        return this.sendMsg(scratchMsg);
    }

    private boolean sendMsg(String msg) {
        if (this.out == null) {
            System.err.println("Output stream error");
            return false;
        }
        try {
            byte[] sizeBytes = this.intToByteArray(msg.length());
            for (int i = 0; i < 4; ++i) {
                this.out.write(sizeBytes[i]);
            }
            this.out.write(msg.getBytes());
        }
        catch (IOException e) {
            System.err.println("Couldn't send: " + msg);
            return false;
        }
        return true;
    }

    private byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public ScratchMessage readMsg() {
        if (this.in == null) {
            System.err.println("Input stream error");
            return null;
        }
        ScratchMessage scratchMsg = null;
        int msgSize = this.readMsgSize();
        if (msgSize > 0) {
            try {
                byte[] buf = new byte[msgSize];
                this.in.read(buf, 0, msgSize);
                String msg = new String(buf);
                scratchMsg = new ScratchMessage(msg);
            }
            catch (IOException e) {
                System.err.println("Message read error: " + e);
            }
        }
        return scratchMsg;
    }

    private int readMsgSize() {
        int msgSize = -1;
        try {
            byte[] buf = new byte[4];
            this.in.read(buf, 0, 4);
            msgSize = ScratchIO.byteArrayToInt(buf);
        }
        catch (IOException e) {
            System.err.println("Header read error: " + e);
        }
        return msgSize;
    }

    private static int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }
}

