/*
 * Decompiled with CFR 0.152.
 */
package infchem.realrobots.scratch;

import infchem.realrobots.scratch.StringToks;

public class ScratchMessage {
    public static final int BROADCAST_MSG = 0;
    public static final int SENSOR_UPDATE_MSG = 1;
    public static final int UNKNOWN_MSG = 2;
    private int msgType = 2;
    private String msgTypeStr = "unknown";
    private String varName = null;
    private String valStr = null;

    public ScratchMessage(String msg) {
        String[] args = StringToks.parseTokens(msg);
        if (args.length < 2) {
            System.err.println("Incorrectly formatted message");
        } else {
            this.msgTypeStr = args[0].toLowerCase();
            if (this.msgTypeStr.equals("broadcast")) {
                this.msgType = 0;
            } else if (this.msgTypeStr.equals("sensor-update")) {
                this.msgType = 1;
            } else {
                System.err.println("Unknown message type");
            }
            this.varName = this.extractName(args[1]);
            if (this.msgType == 0 && args.length > 2) {
                System.err.println("Ignoring extra arguments in broadcast message");
            } else if (this.msgType == 1) {
                if (args.length < 3) {
                    System.err.println("sensor-update message has no value");
                } else {
                    this.valStr = args[2];
                    if (args.length > 3) {
                        System.err.println("Ignoring extra arguments in sensor-update message");
                    }
                }
            }
        }
    }

    private String extractName(String nm) {
        if (nm.charAt(0) == '\"') {
            nm = nm.substring(1, nm.length() - 1);
        }
        if (nm.startsWith("Scratch-")) {
            nm = nm.substring(8);
        }
        return nm;
    }

    public int getMessageType() {
        return this.msgType;
    }

    public String getMessageTypeStr() {
        return this.msgTypeStr;
    }

    public String getName() {
        return this.varName;
    }

    public String getValue() {
        return this.valStr;
    }

    public String toString() {
        if (this.msgType == 0) {
            return this.msgTypeStr + " " + this.varName;
        }
        if (this.msgType == 1) {
            return this.msgTypeStr + " " + this.varName + " " + this.valStr;
        }
        return this.msgTypeStr;
    }
}

