/*
 * Decompiled with CFR 0.152.
 */
package infchem.realrobots.scratch;

import java.util.ArrayList;

public class StringToks {
    private static String str;
    private static int index;

    public static String[] parseTokens(String s) {
        str = s;
        index = 0;
        ArrayList<String> argsList = new ArrayList<String>();
        int tokCount = 0;
        while (index != str.length()) {
            StringToks.skipWhite();
            if (index == str.length()) break;
            char c = str.charAt(index);
            String arg = c == '\"' ? StringToks.readQuotedString() : StringToks.readString();
            argsList.add(arg);
            ++tokCount;
        }
        String[] args = new String[tokCount];
        for (int i = 0; i < tokCount; ++i) {
            args[i] = (String)argsList.get(i);
        }
        return args;
    }

    private static void skipWhite() {
        while (index != str.length() && Character.isWhitespace(str.charAt(index))) {
            ++index;
        }
    }

    private static String readQuotedString() {
        StringBuilder buffer = new StringBuilder();
        ++index;
        block9: while (index != str.length()) {
            char c = str.charAt(index);
            switch (c) {
                case '\"': {
                    ++index;
                    break block9;
                }
                case '\\': {
                    if (index < str.length() - 1) {
                        ++index;
                    }
                    c = str.charAt(index);
                    switch (c) {
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                        }
                    }
                    buffer.append(c);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++index;
        }
        return buffer.toString();
    }

    private static String readString() {
        int start = index;
        while (index != str.length() && !Character.isWhitespace(str.charAt(index))) {
            ++index;
        }
        return str.substring(start, index);
    }
}

