/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.opengl.util.av.AudioSink;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class JavaSoundAudioSink
implements AudioSink {
    public static final int BUFFER_SIZE = 1000;
    public static final int SAMPLES_PER_BUFFER = 500;
    private static final boolean staticAvailable;
    private AudioFormat format;
    private DataLine.Info info;
    private SourceDataLine auline;
    private int bufferCount;
    private final byte[] sampleData = new byte[1000];
    private boolean initialized = false;
    private AudioSink.AudioFormat chosenFormat = null;
    private volatile boolean playRequested = false;
    private float volume = 1.0f;

    public String toString() {
        return "JavaSoundSink[init " + this.initialized + ", dataLine " + this.info + ", source " + this.auline + ", bufferCount " + this.bufferCount + ", chosen " + this.chosenFormat + ", jsFormat " + this.format;
    }

    @Override
    public final float getPlaySpeed() {
        return 1.0f;
    }

    @Override
    public final boolean setPlaySpeed(float f) {
        return false;
    }

    @Override
    public final float getVolume() {
        return this.volume;
    }

    @Override
    public final boolean setVolume(float f) {
        this.volume = f;
        return true;
    }

    @Override
    public AudioSink.AudioFormat getPreferredFormat() {
        return DefaultFormat;
    }

    @Override
    public final int getMaxSupportedChannels() {
        return 2;
    }

    @Override
    public final boolean isSupported(AudioSink.AudioFormat audioFormat) {
        return true;
    }

    @Override
    public boolean init(AudioSink.AudioFormat audioFormat, float f, int n, int n2, int n3) {
        if (!staticAvailable) {
            return false;
        }
        this.format = new AudioFormat(audioFormat.sampleRate, audioFormat.sampleSize, audioFormat.channelCount, audioFormat.signed, !audioFormat.littleEndian);
        this.info = new DataLine.Info(SourceDataLine.class, this.format);
        Arrays.fill(this.sampleData, (byte)0);
        try {
            this.auline = (SourceDataLine)AudioSystem.getLine(this.info);
            this.auline.open(this.format);
            this.auline.start();
            System.out.println("JavaSound audio sink");
            this.initialized = true;
            this.chosenFormat = audioFormat;
        }
        catch (Exception exception) {
            this.initialized = false;
        }
        return true;
    }

    @Override
    public final AudioSink.AudioFormat getChosenFormat() {
        return this.chosenFormat;
    }

    @Override
    public boolean isPlaying() {
        return this.playRequested && this.auline.isRunning();
    }

    @Override
    public void play() {
        if (null != this.auline) {
            this.playRequested = true;
            this.playImpl();
        }
    }

    private void playImpl() {
        if (this.playRequested && !this.auline.isRunning()) {
            this.auline.start();
        }
    }

    @Override
    public void pause() {
        if (null != this.auline) {
            this.playRequested = false;
            this.auline.stop();
        }
    }

    @Override
    public void flush() {
        if (null != this.auline) {
            this.playRequested = false;
            this.auline.stop();
            this.auline.flush();
        }
    }

    @Override
    public final int getEnqueuedFrameCount() {
        return 0;
    }

    @Override
    public int getFrameCount() {
        return 1;
    }

    @Override
    public int getQueuedFrameCount() {
        return 0;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void destroy() {
        this.initialized = false;
        this.chosenFormat = null;
    }

    @Override
    public AudioSink.AudioFrame enqueueData(int n, ByteBuffer byteBuffer, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = byteBuffer.position();
        byteBuffer.get(byArray, 0, n2);
        byteBuffer.position(n3);
        int n4 = 0;
        int n5 = n2;
        while (n5 > 0) {
            int n6 = this.auline.write(byArray, n4, n2);
            n5 -= n6;
            n4 += n6;
        }
        this.playImpl();
        return new AudioSink.AudioDataFrame(n, this.chosenFormat.getBytesDuration(n2), byteBuffer, n2);
    }

    @Override
    public int getQueuedByteCount() {
        return this.auline.getBufferSize() - this.auline.available();
    }

    @Override
    public int getFreeFrameCount() {
        return this.auline.available();
    }

    @Override
    public int getQueuedTime() {
        return this.getQueuedTimeImpl(this.getQueuedByteCount());
    }

    private final int getQueuedTimeImpl(int n) {
        int n2 = this.chosenFormat.sampleSize >>> 3;
        return n / (this.chosenFormat.channelCount * n2 * (this.chosenFormat.sampleRate / 1000));
    }

    @Override
    public final int getPTS() {
        return 0;
    }

    static {
        boolean bl = false;
        try {
            AudioSystem.getAudioFileTypes();
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        staticAvailable = bl;
    }
}

