//Die Klasse Bild verwaltet die Malfläche, den UndoSpeicher und ist für das Laden und Speichern von Bildinhalten zuständig.
//Das Schlüsselwort "public" muss hier stehen, weil sonst die Callback-Funktion für das Speichern und Laden der Bilder unsichtbar ist.
public class Bild {
  
  //Referenz auf die Bildfläche
  PGraphics pg;
  //Referenz auf den UndoSpeicher
  UndoSpeicher undoSpeicher;
  //Wird vor allem für die korrekte Durchführung der undo-Funktion benötigt
  boolean wirdBearbeitet = false;
 
  //Konstruktor...
  Bild(int breite, int hoehe) {
    //Bildfläche wird erzeugt
    pg = createGraphics(breite, hoehe);
    //Die Farbcodierung der Bildfläche wird gesetzt und mit weiß gefüllt.
    pg.beginDraw();
    pg.colorMode(RGB, 100);
    pg.background(100);
    pg.endDraw();
    //Der UndoSpeicher wird initialisert.
    //"this" ist eine Referenz auf das Bild, die der UndoSpeicher benötigt.
    undoSpeicher = new UndoSpeicher(this);
  }
  
  //Zeigt die Bildfläche im Hauptfenster an
  void anzeigen() {
    image(pg, dXBild, dYBild);
  }
  
  //Wird von mouseReleased() aufgerufen und lädt den aktuellen Bildinhalt in den UndoSpeicher
  void malenBeenden(){
    wirdBearbeitet = false;
    undoSpeicher.save();
  }
  
  //Wird immer dann aufgerufen, wenn die Bildgröße sich ändert 
  void bildGroesseAendern(int breite, int hoehe) {
    //Erzeugt neue Bildfläche
    PGraphics pgNeu = createGraphics(breite, hoehe);
    //Aktionen wie im Kontruktor von Bild
    pgNeu.beginDraw();
    pgNeu.colorMode(RGB, 100);
    pgNeu.background(100);
    //Vorheriger Bildinhalt wird in die neue Bildfläche kopiert
    pgNeu.image(pg, 0, 0);
    pgNeu.endDraw();
    //Referenz wird auf die neue Bildfläche gesetzt
    pg = pgNeu;
    //Diese Funktion steht in der Datei "funktionen.pde".
    //Sie sorgt für die Anpassung der Größe des Hauptfensters zur vollständigen Darstellung der neuen Bildfläche.
    aktualisiereFensterGroesse();
  }
  
  //Wird aufgerufen, wenn die Taste "z" gedrückt wurde;
  //Macht den letzen Pinselstrich rückgängig
  void undo(){
    //Der UndoSpeicher liefert den zuletzt gespeicherten Bildinhalt.
    PImage letztesBild = undoSpeicher.undo();
    //Da ein früherer Bildinhalt eine andere Größe haben kann als der aktuelle, wird die Größe angepasst.
    bildGroesseAendern(letztesBild.width, letztesBild.height);
    pg.beginDraw();
    //Der zuletzgespeicherte Bildinhalt wird in die Bildfläche kopiert
    pg.image(letztesBild, 0, 0);
    pg.endDraw(); 
  }
  
  //Wird aufgerufen, wenn die Taste "l" gedrückt wurde
  //Füllt die Bildfläche mit weißer Farbe
  void loeschen() {
    pg.beginDraw();
      pg.fill(100);
      pg.noStroke();
      pg.rect(0, 0, pg.width, pg.height);
    pg.endDraw();
    malenBeenden();   
  }
  
  //Prüft, ob die Maus sich in der Bildfläche befindet;
  //Nur dann soll gemalt werden!
  //Wird von Pinsel.zeichnen() aufgerufen
  boolean mausImBild(){
    return mouseX > dXBild
    && mouseX <  bild.pg.width + dXBild
    && mouseY > dYBild
    && mouseY < dYBild +  bild.pg.height;
  }

  //Wird aufgerufen, wenn die Taste "s" gedrückt wurde;
  //Öffnet ein Dialogfenster zum Speichern des aktuellen Bildinhaltes
  void speichern() {
    //Das zweite Argument ist der Name einer "Callback-Funktion".
    //Sie wird automatisch aufgerufen, wenn im Dialogfenster "Speichern" gedrückt wurde.
    selectOutput("Bild Speichern:", "speichernAbschliessen", null, this);
  }
  
  //Die entsprechende Callback-Funktion
  void speichernAbschliessen(File file) {
    //Wenn der Pfad nicht null ist, wird der Bildinhalt unter dem Pfad gespeichert.
    if (file != null) {
      pg.save(file.getPath());
    }
  }
  
  //Wird aufgerufen, wenn die Taste "s" gedrückt wurde
  //Öffnet ein Dialogfenster zum Speichern eines Bildes
  //Arbeitet ebenfalls mit einer Callback-Funktion
  void oeffnen() {
    selectInput("Bild Öffnen:", "oeffnenAbschliessen", null, this);
  }
  
  //Die entsprechende Callback-Funktion
  public void oeffnenAbschliessen(File file) {
    if (file != null) {
      //Der neue Bildinhalt
      PImage geladenesBild = loadImage(file.getPath());
      //Größenanpassung
      bildGroesseAendern(geladenesBild.width, geladenesBild.height);
      pg.beginDraw();
      //Neuer Bildinhalt wird in die Bildfläche kopiert
      pg.image(loadImage(file.getPath()), 0, 0);
      pg.endDraw();
      //Auch diese Bildänderung wird im UndoSpeicher gespeichert.
      undoSpeicher.save();
    }
  }
  
}