//Die Basisklasse aller Pinsel;
//Sie stellt alle Eigenschaften und Funktionen bereit, die alle Pinsel brauchen werden.
//Da dieser Pinsel nicht malen kann, verhindert das Schlüsselwort "abstract", dass Objekte dieser Klasse erzeugt werden können.
abstract class Pinsel {

  //Für die Kontrollelemente zur Steuerung der Pinseleigenschaften
  ControlP5 cp5;
  //Referenz auf die Bildfläche, kann bild.pg oder vorschau.pg sein
  PGraphics pg;
  //Kooordinatenverschiebung zur Berechnung der Strichposition bild.pg oder vorschau.pg
  int dX, dY;
  //Referenz auf ein Textlabel zur Anzeige des Pinselnamens;
  //Ist eine Klasse der Library ControlP5
  Textlabel label;

  //Konstruktor...
  Pinsel() {
    //Initialisierung von ControlP5
    cp5 = new ControlP5(app);
    //Positionierung der Kontrollelemente
    cp5.setPosition(0, 140);
    //Hinzugefügte Kontrollelemente werden automatisch vertikal angeordnet.
    cp5.setAutoAddDirection(ControlP5.VERTICAL);
    //Beschriftung der Kontrollelemente wird schwarz gesetzt.
    cp5.setColorCaptionLabel(0);

    //Das Label zur Anzeige der Pinselnamen wird hinzugefügt.
    label = cp5.addTextlabel("label");
    //Hintergundfarbe ist weiß.
    label.setColorValue(#000000);
    //Schrifttyp und Schriftgröße des Labels
    label.setFont(createFont("Arial", 15));
    
    //Ein Slider für den Radius wird hinzugefügt.
    cp5.addSlider("radius", 0.1, 1).setValue(0.3);
    
    //Die Kontrollelemente sind zunächst unsichtbar, sie werden sichtbar geschaltet, wenn der Pinsel ausgewählt wurde.
    cp5.setVisible(false);
    
    //Bei Programmstart muss pg initialisiert sein.
    pg = bild.pg;
  }

  //Berechnet den Radius abhängig von Zustand des entsprechenden Silders;
  //Arbeitet mit einer Potenzfunktion, damit die Auflösung des Sliders bei geringen Radien feiner ist als bei hohen Radien
  float radius() {
    return 100 * pow(cp5.getValue("radius"), 3);
  }

  //Stellt fest, ob der Pinsel malt oder nicht;
  //Von Pinsel abgeleitete Klassen brechen zeichnen() ab, wenn der Pinsel nicht malt.
  boolean pinselMalt() {
    return bild.wirdBearbeitet || vorschau.wirdBearbeitet;
  }

  //Wird von draw() aufgerufen;
  //Hat in der Basisklasse Pinsel die Aufgabe festzustellen, ob und in welches PGraphic-Objekt gemalt wird;
  //Setzt dann entsprechend die Referenz auf das PGraphics-Objekt und die Koordinatenverschiebung
  void zeichnen() {
    if (bild.mausImBild() && !vorschau.wirdBearbeitet) {
      bild.wirdBearbeitet = true;
      pg = bild.pg;
      dX = -dXBild;
      dY = -dYBild;
    } else if (vorschau.mausImBild() && !bild.wirdBearbeitet) {
      vorschau.wirdBearbeitet = true;
      pg = vorschau.pg;
      dX = -dXVorschau;
      dY = -dYVorschau;
    }
  }

  //Schaltet die Kontrollelemente sichtbar / unsichtbar;
  //Wird von pinselWaehlen() aufgerufen
  void aktiv(boolean aktiv) {
    cp5.setVisible(aktiv);
  }
}