/*
Im folgenden werden alle Arbeitsschritte demonstriert, die für die Programmierung 
eines jeden neuen Pinsels notwendig sind.

Das Beispiel ist bewusst schlicht gehalten, um den Blick auf das Wesentliche zu 
konzentrieren. Es handelt sich um einen Pinsel, der Kreise in Graustufen malt. 

1. Erzeugen Sie einen neuen Tab mit dem Namen "KreisPinsel", indem Sie auf das 
Dreiecksymbol ganz rechts in der Tableiste klicken und "Neuer Tab" auswählen
und den Namen eingeben.

2. Kopieren Sie folgenden Code in den neuen Tab:

//////////////////////////////////////////////
class KreisPinsel extends Pinsel {

  KreisPinsel() {
    super();
    //Ein Slider für den Grauwert wird hinzugefügt:
    cp5.addSlider("grauwert").setValue(50);
    //Der Standardwert für Radius wird auf 0.5 gesetzt:
    cp5.getController("radius").setValue(0.5);
    label.setText(" KREISPINSEL");
  }

  void zeichnen() {
    super.zeichnen();
    if ( !pinselMalt()) {
      return;
    }
    pg.beginDraw();
    //Die Kreise haben keine Umrandung
    pg.noStroke();
    //Die Füllfarbe wird über den Zustand des Sliders "grauwert" gesetzt:
    pg.fill(cp5.getValue("grauwert"));
    //Der Kreis wird gezeichnet:
    pg.ellipse(mouseX + dX, mouseY + dY, radius(), radius());
    pg.endDraw();
  }
}
//////////////////////////////////////////////

Damit der neue Pinsel auch benutzt werden kann, müssen noch drei Stellen im Code 
ergänzt werden:

3. In der Datei "mal_o_mat_2_0.pde" in Zeile 51 folgende Zeile einfügen:
KreisPinsel kreisPinsel;
(Jetzt steht eine Variable vom Typ KreisPinsel zur Verfügung, die eine Referenz auf diesen Pinsel speichern kann.)

4. In der Datei "mal_o_mat_2_0.pde" in die switch-Anweisung folgenden drei Zeilen einfügen:
case '3':
  pinselWaehlen(kreisPinsel);
  break;
(Nun kann mit einen Druck auf die Taste "3" der KreisPinsel gewählt werden.)

5. In der Datei "funktionen.pde" in die Funktion initialisiere() in Zeile 98 folgende Codezeile einfügen:
kreisPinsel = new KreisPinsel();
(Die globale Variable kreisPinsel wird initialisiert.)

Nun sollte der neue KreisPinsel über die Taste "3" wähl- und benutzbar sein!
Ich wünsche Ihnen viel Vergnügen bei der Entwicklung eigener Pinsel und freue mich
auf Ihren Kreationen, Fragen, Ideen: <mail@pitnoack.de>

*/