/*
Mal-o-Mat is a painting software, written in Processing
2017 by Pit Noack for c't magazin, issue 24/2017
Download fee-based article: <http://ct.de/ymqc>
The development of future versions will be documented here: <http://www.maschinennah.de/>

Mal-o-Mat is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Mal-o-Mat is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details:
<http://www.gnu.org/licenses/>

@author   Pit Noack <mail@pitnoack.de>
@modified 03/11/2017
@version  2.0
*/

//Die Library ControlP5 wird bereitgestellt.
import controlP5.*;

//Referenz auf das Processing-Programm selbst, das eine Instanz von PApplet ist;
//Wird zur Initialisierung der ControlP5-Instanzen der Pinsel benötigt
PApplet app = this;

//Für die Kontrollelemente im Startfenster
ControlP5 cp5;

//Für das Layout des Hauptfensters
int kontrollfeldBreite = 180;
int randBreite = 5;

//Koordinaten der oberen linken Ecke von Bild und Pinselvorschau;
//Werden für deren Darstellung und die Berechnung der Position der Pinselstriche benötigt
int dXBild = kontrollfeldBreite;
int dYBild = randBreite;
int dXVorschau = randBreite;
int dYVorschau = randBreite;

//Referenz auf den aktuell ausgewählten Pinsel
Pinsel aktuellerPinsel;

//Referenzen auf alle wählbaren Pinsel
RadierPinsel radierPinsel;
LinienPinsel linienPinsel;
SpruehPinsel spruehPinsel;

//Referenzen auf das Bild und die PinselVorschau
Bild bild;
PinselVorschau vorschau;

//Wird automatisch aufgerufen, wenn das Programm startet
void setup() {
  //Die Größe des Hauptfensters kann zur Laufzeit geändert werden.
  surface.setResizable(true);
  //Die Größe des Startfensters wird gesetzt.
  surface.setSize(300, 230);
  //Maximale Werte für Rot, Grün und Blau 100 statt 255
  colorMode(RGB, 100);
  //Startfenster wird grau gefüllt
  background(90);
  //Diese Funktion steht in der Datei "funktionen.pde".
  //Dort werden alle Initialisierungsschritte bis zum Öffnen des Hauptfensters erledigt.
  initStartKontrollelemente();
}

//Wird automatisch aufgerufen, wenn das Programmfenster neu gezeichnet wird
void draw() {
  //Füllt das Fenster grau
  background(90);
  //Wenn das Bild nicht initialisiert ist wird abgebrochen.
  if (bild == null) {
    return;
  }
  //Wenn die Maus gedrückt ist, führt der aktuelle Pinsel die Funktion zeichnen() aus.
  if (mousePressed) {
    aktuellerPinsel.zeichnen();
  }
  //Bild und Vorschau werden angezeigt.
  bild.anzeigen();
  vorschau.anzeigen();
  //Beschriftung der PinselVorschau und Hinweis auf die Tastaturkürzelanzeige werden eingefügt.
  fill(0);
  textSize(11);
  text("Pinselvorschau", randBreite, 120);
  text("'m' --> Tastaturkürzel anzeigen", randBreite, height - 10);
}

//Wird automatisch aufgerufen, wenn die Maustaste losgelassen wird;
//Dient hauptsächlich der korrekten Durchführung der Undo-Funktion
void mouseReleased() {
   //Wenn das Bild nicht initialisiert ist wird abgebrochen.
  if (bild == null) {
    return;
  }
  //Wenn das Bild in Bearbeitung ist wird bild.malenBeenden() aufgerufen.
  //malenBeenden() sorgt für die Speicherung des aktuellen Bildzustandes im UndoSpeicher.
  if (bild.wirdBearbeitet == true) {
    bild.malenBeenden();
  }
  if (vorschau.wirdBearbeitet == true) {
    vorschau.malenBeenden();
  }
}

//Wird automatisch aufgerufen, wenn eine Taste gedrückt wurde
void keyPressed() {
  //Wenn das Bild nicht initialisiert ist wird abgebrochen.
  if (bild == null) {
    return;
  }
  //Da die Anzeige der Tastaturkürzel den loop (= automatische Ausführung von draw() ) stoppt, wird er hier in jedem Fall fortgesetzt.
  loop();
  //Aktionen abhängig von der gedrückten Taste:
  switch(key) {
  case '1':
    pinselWaehlen(linienPinsel);
    break;
  case '2':
    pinselWaehlen(spruehPinsel);
    break;
  case '0':
    pinselWaehlen(radierPinsel);
    break;
  case 'z':
    bild.undo();
    break;
  case 's':
    bild.speichern();
    break;
  case 'o':
    bild.oeffnen();
    break;
  case 'l':
    bild.loeschen();
    break;
  case 'r':
    reset();
    break;
  case 'm':
    //Tastaturkürzelanzeige hält den Loop an
    noLoop();
    tastaturkuerzelAnzeigen();
    break;
  default:
    break;
  }
}