/*
   Basecamp - ESP32 library to simplify the basics of IoT projects
   Written by Merlin Schumacher (mls@ct.de) for c't magazin für computer technik (https://www.ct.de)
   Licensed under GPLv3. See LICENSE for details.
   */

#include <pgmspace.h>
//
// converted data/* to gzipped flash variables
//


#define basecamp_css_gz_len 644
const uint8_t basecamp_css_gz[] PROGMEM {
  0x1f, 0x8b, 0x08, 0x08, 0xd6, 0x40, 0x5f, 0x5a, 0x00, 0x03, 0x62, 0x61,
  0x73, 0x65, 0x63, 0x61, 0x6d, 0x70, 0x2e, 0x63, 0x73, 0x73, 0x00, 0xc5,
  0x54, 0xcb, 0x8e, 0x9b, 0x30, 0x14, 0x5d, 0x87, 0xaf, 0xb0, 0x84, 0x2a,
  0x85, 0x0a, 0x47, 0x40, 0x92, 0x99, 0x0e, 0x51, 0xab, 0x76, 0x53, 0x75,
  0xdd, 0x6d, 0x35, 0x8b, 0x6b, 0x30, 0x60, 0x8d, 0xb1, 0x91, 0x6d, 0x42,
  0xd2, 0x6a, 0xfe, 0xbd, 0xb6, 0x21, 0x4c, 0x5e, 0xa3, 0x2e, 0xab, 0xc4,
  0x60, 0xee, 0x3d, 0xb6, 0x8f, 0xcf, 0x7d, 0x34, 0xa6, 0xe5, 0xe8, 0x4f,
  0xb0, 0xa8, 0xa4, 0x30, 0xb8, 0x82, 0x96, 0xf1, 0x63, 0x8e, 0x7e, 0x4a,
  0x22, 0x8d, 0x8c, 0xd1, 0x0f, 0xca, 0xf7, 0xd4, 0xb0, 0x02, 0x62, 0xf4,
  0x4d, 0x31, 0xe0, 0x31, 0xd2, 0x20, 0x34, 0xd6, 0x54, 0xb1, 0x6a, 0x17,
  0x2c, 0x38, 0x13, 0x14, 0x37, 0x94, 0xd5, 0x8d, 0xc9, 0x51, 0xba, 0xda,
  0xee, 0x82, 0xd7, 0x20, 0xf8, 0xda, 0xd2, 0x92, 0x01, 0x5a, 0xb6, 0x4c,
  0xe0, 0x92, 0xee, 0x59, 0x41, 0xf1, 0xc0, 0x4a, 0xd3, 0xe4, 0x68, 0x93,
  0x24, 0xdd, 0x21, 0x72, 0x87, 0x85, 0x83, 0x82, 0xae, 0xa3, 0xca, 0xcd,
  0x17, 0xa3, 0xf7, 0x53, 0xf2, 0xc1, 0xee, 0xb8, 0x68, 0xe1, 0x70, 0x82,
  0xa7, 0x89, 0xc3, 0x8f, 0x46, 0x55, 0x33, 0x91, 0xa3, 0x04, 0x41, 0x6f,
  0xa4, 0xb5, 0xbc, 0xba, 0x83, 0x9a, 0x74, 0xe6, 0x3d, 0x4c, 0x1c, 0xd6,
  0x49, 0x72, 0x45, 0x2b, 0x4d, 0xdd, 0xbe, 0x0e, 0x9d, 0xc5, 0xa8, 0x59,
  0xdb, 0xb1, 0xb9, 0x59, 0x25, 0xa4, 0x6a, 0x81, 0xbf, 0xb7, 0xb0, 0x73,
  0xf8, 0x42, 0x72, 0xa9, 0x72, 0xa4, 0x6a, 0x02, 0xcb, 0x24, 0xf6, 0xbf,
  0xd5, 0x63, 0x1a, 0x79, 0x00, 0x07, 0x42, 0xbd, 0x84, 0x25, 0xd3, 0x1d,
  0x87, 0x63, 0x4e, 0xb8, 0x2c, 0x5e, 0xbc, 0x2b, 0x60, 0xa2, 0xeb, 0xcd,
  0x2f, 0x73, 0xec, 0xe8, 0x67, 0x43, 0x0f, 0xe6, 0x39, 0x46, 0x67, 0x96,
  0x0e, 0xb4, 0x1e, 0xa4, 0x2a, 0x2f, 0xad, 0xa2, 0x6f, 0x09, 0x55, 0x27,
  0x5b, 0x2e, 0xa4, 0x59, 0x7a, 0xc7, 0x73, 0x74, 0xe7, 0x8c, 0x49, 0x1a,
  0x6c, 0xc3, 0x65, 0x64, 0x9b, 0xa7, 0xb4, 0xb5, 0xb6, 0x51, 0x3f, 0x2b,
  0xdf, 0x78, 0x81, 0xb3, 0xbd, 0x49, 0x6f, 0x61, 0xe2, 0xf2, 0x3c, 0xdd,
  0x93, 0x96, 0x39, 0x66, 0xa3, 0x33, 0x46, 0xb0, 0x1a, 0x67, 0xee, 0x38,
  0x62, 0xe9, 0x51, 0xe5, 0x24, 0x12, 0x74, 0x77, 0xfa, 0xc4, 0x0a, 0x4a,
  0xd6, 0xeb, 0x1c, 0x65, 0x3e, 0x3c, 0x04, 0x8a, 0x97, 0x5a, 0xc9, 0x5e,
  0x94, 0x39, 0x0a, 0xb3, 0x07, 0x78, 0x78, 0x82, 0x1d, 0x9a, 0x25, 0x1b,
  0x1a, 0x66, 0xdc, 0xd2, 0xa2, 0x57, 0xda, 0x7d, 0x77, 0x92, 0x09, 0x43,
  0xd5, 0x6e, 0x8a, 0x81, 0x66, 0xbf, 0xa9, 0xcb, 0x9d, 0x6c, 0xeb, 0xa9,
  0x5f, 0x66, 0xd4, 0xd6, 0xe7, 0x04, 0x91, 0x07, 0xac, 0x1b, 0x28, 0xe5,
  0x30, 0x07, 0x00, 0x4d, 0xff, 0x55, 0xba, 0x89, 0x90, 0x4d, 0x12, 0xc7,
  0xc4, 0x0f, 0x3b, 0x8f, 0x6f, 0x41, 0xd9, 0x08, 0x4a, 0xed, 0xd8, 0xbe,
  0x07, 0x9a, 0x30, 0xeb, 0x09, 0x87, 0xfd, 0xdd, 0xee, 0xaa, 0x97, 0x37,
  0x72, 0x4f, 0xd5, 0x3d, 0x0d, 0x4f, 0x9e, 0x6b, 0x25, 0x47, 0xbb, 0xd7,
  0x73, 0xd6, 0x0a, 0x4f, 0xfa, 0x84, 0x19, 0x21, 0x04, 0xca, 0xab, 0x7b,
  0x26, 0x9e, 0x88, 0x1b, 0xc9, 0x65, 0xd2, 0xd9, 0x0b, 0xc7, 0x89, 0x67,
  0xf8, 0x78, 0xc7, 0x99, 0x39, 0xe7, 0x7c, 0x05, 0xf7, 0xb8, 0xf0, 0x67,
  0x63, 0xc2, 0xae, 0x34, 0x67, 0x2d, 0x1e, 0x63, 0xf9, 0x16, 0xe4, 0x29,
  0x87, 0xe6, 0xea, 0x1b, 0x63, 0x7b, 0xe1, 0xd2, 0xe6, 0xc8, 0x69, 0xae,
  0x25, 0x67, 0xe5, 0x9b, 0x8f, 0xb5, 0x50, 0xdb, 0x10, 0xba, 0xc8, 0x81,
  0xc2, 0xb5, 0xcb, 0x0d, 0x2a, 0xcc, 0xd2, 0x48, 0xa4, 0x5c, 0x18, 0x27,
  0xa5, 0xd3, 0xa7, 0x2c, 0x9e, 0x47, 0x74, 0x23, 0x7f, 0x14, 0xd9, 0x72,
  0xb7, 0x59, 0xe3, 0xd8, 0x55, 0x60, 0xfe, 0x45, 0x6e, 0xfd, 0xdf, 0xc8,
  0x0d, 0xa0, 0x04, 0x13, 0xf5, 0x59, 0x4f, 0x08, 0xbf, 0xfb, 0xa6, 0x73,
  0xde, 0x51, 0x88, 0xe4, 0xa5, 0x57, 0x3a, 0x2c, 0xa4, 0xa8, 0x58, 0x5d,
  0xd9, 0x06, 0x73, 0x5e, 0xbc, 0x15, 0xa7, 0x8e, 0xbf, 0x7b, 0x61, 0xd7,
  0x09, 0x6d, 0x95, 0xd8, 0xe7, 0xcd, 0x8a, 0x2f, 0xe8, 0xa3, 0xef, 0x55,
  0x16, 0x66, 0xe3, 0x81, 0xe6, 0x82, 0x0e, 0x7d, 0xc7, 0xb1, 0x10, 0x0d,
  0x7b, 0x7a, 0xda, 0x7b, 0x2a, 0xd4, 0xd4, 0x91, 0x79, 0x0d, 0xfe, 0x02,
  0xed, 0x6a, 0x16, 0x96, 0xd6, 0x05, 0x00, 0x00
};
#define basecamp_js_gz_len 1467
const uint8_t basecamp_js_gz[] PROGMEM {
  0x1f, 0x8b, 0x08, 0x08, 0xd6, 0x40, 0x5f, 0x5a, 0x00, 0x03, 0x62, 0x61,
  0x73, 0x65, 0x63, 0x61, 0x6d, 0x70, 0x2e, 0x6a, 0x73, 0x00, 0xc5, 0x57,
  0xcd, 0x72, 0xdb, 0x36, 0x10, 0x3e, 0x4b, 0x4f, 0xb1, 0x41, 0x66, 0x62,
  0x2a, 0x96, 0xe9, 0xa4, 0xee, 0x49, 0xaa, 0xd3, 0x26, 0xb2, 0x93, 0xba,
  0x75, 0x12, 0x4f, 0xe4, 0x69, 0x3a, 0xe3, 0xf1, 0x01, 0x22, 0x57, 0x12,
  0x62, 0x88, 0x50, 0x01, 0xd0, 0xaa, 0xea, 0xd1, 0x9b, 0xf5, 0xd6, 0x17,
  0xeb, 0x02, 0x04, 0xff, 0x24, 0xc5, 0xed, 0xa5, 0x53, 0x1e, 0x24, 0x12,
  0xd8, 0xfd, 0xf6, 0xef, 0xc3, 0x72, 0x79, 0xfc, 0xbc, 0x0b, 0x00, 0x6f,
  0xb8, 0xc1, 0x84, 0x2f, 0x96, 0x70, 0x04, 0xe7, 0xe3, 0xab, 0x93, 0x6f,
  0x40, 0x8a, 0x89, 0xe6, 0x7a, 0x0d, 0x56, 0x81, 0x11, 0x8b, 0xa5, 0x14,
  0x53, 0xba, 0x9f, 0x23, 0x4c, 0xb8, 0x11, 0x89, 0x01, 0x35, 0x85, 0x0b,
  0x75, 0x0d, 0x4b, 0xad, 0xbe, 0x60, 0x62, 0x8d, 0x83, 0xf8, 0xac, 0x85,
  0xb5, 0x98, 0xc1, 0x64, 0x0d, 0xef, 0x51, 0x4b, 0x91, 0xc1, 0x38, 0x99,
  0xe7, 0x0b, 0x9e, 0xcc, 0x51, 0x43, 0xb4, 0x90, 0xe6, 0x87, 0xc4, 0xc6,
  0x29, 0xf6, 0x60, 0xaa, 0x34, 0x24, 0x07, 0x16, 0x16, 0x7c, 0xc6, 0xff,
  0x20, 0xb1, 0xe9, 0x5f, 0x7f, 0xd2, 0x82, 0x5a, 0x2c, 0x73, 0x4b, 0x92,
  0x16, 0x93, 0x79, 0x26, 0xee, 0x20, 0x9a, 0x5b, 0xbb, 0x34, 0x83, 0xe3,
  0xe3, 0xd5, 0x6a, 0x15, 0x17, 0x9a, 0xce, 0xca, 0xa5, 0x48, 0x30, 0x33,
  0x98, 0x42, 0x9e, 0xa5, 0x24, 0xfd, 0xee, 0xea, 0xf2, 0xfe, 0x24, 0x86,
  0x31, 0x22, 0x5c, 0x5e, 0x8c, 0xce, 0x3f, 0x8c, 0xcf, 0x3d, 0x7c, 0x8a,
  0x96, 0x0b, 0x69, 0x62, 0xa7, 0xf1, 0xfc, 0xb8, 0xdb, 0xfd, 0x62, 0x54,
  0x76, 0xc6, 0x2d, 0x87, 0x53, 0x60, 0x29, 0xfd, 0xc7, 0x6e, 0x81, 0x0d,
  0xbb, 0xdd, 0x69, 0x9e, 0x25, 0x56, 0xa8, 0x0c, 0xa4, 0xe2, 0x69, 0xd4,
  0x83, 0x87, 0x6e, 0x27, 0x51, 0x99, 0x51, 0x12, 0x63, 0xa9, 0x66, 0xd1,
  0x41, 0x95, 0x17, 0xb7, 0x8f, 0xe9, 0x41, 0x6f, 0xd8, 0xed, 0xdc, 0x73,
  0x0d, 0x1a, 0x7f, 0xcb, 0xd1, 0x58, 0xc2, 0xcb, 0x70, 0x05, 0xbf, 0xbe,
  0xbf, 0xfc, 0x91, 0xbc, 0xfd, 0x54, 0x2c, 0x46, 0x4e, 0xa8, 0x02, 0xb6,
  0x9a, 0x67, 0x66, 0x8a, 0x7a, 0x44, 0x01, 0x4a, 0xb4, 0x58, 0x18, 0xe9,
  0x74, 0x20, 0x5c, 0x0e, 0x2d, 0x2d, 0x5c, 0xfb, 0x69, 0xfc, 0xf1, 0x43,
  0xbc, 0xe4, 0xda, 0x60, 0x64, 0xe7, 0xc2, 0xc4, 0x1a, 0xcd, 0x92, 0x9c,
  0xc1, 0x6b, 0xfc, 0xdd, 0x3a, 0x4c, 0xba, 0x26, 0xb9, 0x90, 0xe9, 0x58,
  0x10, 0x8c, 0x0f, 0x03, 0x25, 0x2e, 0x30, 0xb3, 0x26, 0xec, 0x1a, 0xb4,
  0xef, 0x29, 0xf2, 0x62, 0x6f, 0x41, 0x77, 0x7e, 0x7d, 0x33, 0x84, 0x3d,
  0xfe, 0xbc, 0xa5, 0x04, 0x61, 0x1a, 0xe1, 0xbd, 0x0d, 0x0e, 0xb5, 0xe2,
  0xbe, 0x54, 0xea, 0xce, 0x10, 0x09, 0xee, 0xd0, 0x55, 0x5d, 0x23, 0xac,
  0xb8, 0x01, 0xee, 0xea, 0x3d, 0x21, 0x93, 0x94, 0x70, 0xcb, 0x6d, 0x6e,
  0x60, 0xa4, 0x52, 0x1c, 0xc0, 0x01, 0x1c, 0x96, 0x09, 0x89, 0x8d, 0xdf,
  0x28, 0xfc, 0xe1, 0x69, 0x7a, 0x5e, 0x38, 0x78, 0xad, 0xce, 0xd4, 0x22,
  0x62, 0xf3, 0x97, 0xac, 0xcf, 0x50, 0x6b, 0xa5, 0xe9, 0x7f, 0xa4, 0x72,
  0x99, 0x42, 0xa6, 0xac, 0xcf, 0x2d, 0x11, 0x20, 0x9b, 0x8a, 0x59, 0xae,
  0xb9, 0xf3, 0x72, 0x00, 0x6c, 0x07, 0xb3, 0x0f, 0x0f, 0xcc, 0xd8, 0xb5,
  0x44, 0x46, 0xbb, 0x89, 0x92, 0x4a, 0x0f, 0x34, 0xa6, 0x6c, 0x53, 0xd8,
  0xd2, 0x68, 0x73, 0x9d, 0x15, 0xe1, 0x76, 0x3b, 0xa5, 0xa6, 0xf3, 0xe0,
  0x9e, 0xec, 0x5f, 0x0a, 0x43, 0xd4, 0x44, 0x1d, 0x31, 0x67, 0x8b, 0xf5,
  0x77, 0xaa, 0xd2, 0x7b, 0x54, 0x29, 0xb8, 0xbc, 0x95, 0xbb, 0xa6, 0x8e,
  0x5a, 0x62, 0x16, 0xb1, 0x77, 0xe7, 0xd7, 0x24, 0x55, 0x92, 0xad, 0xb9,
  0x6f, 0x30, 0x4b, 0x1d, 0x2f, 0xba, 0x9b, 0x26, 0xe9, 0xca, 0x98, 0x31,
  0xa4, 0x29, 0x0a, 0xf5, 0xf4, 0x15, 0x31, 0x2b, 0x61, 0x93, 0x79, 0xb9,
  0x14, 0x57, 0x5b, 0xbe, 0x5a, 0x09, 0xf1, 0x12, 0x98, 0xc8, 0xe8, 0xcc,
  0xb0, 0x41, 0xd7, 0x25, 0x40, 0x4c, 0xa1, 0x92, 0x25, 0x5c, 0x5b, 0xc2,
  0xd0, 0x25, 0xf9, 0x04, 0xe5, 0x45, 0xea, 0xc8, 0xef, 0x6f, 0xe9, 0x84,
  0xb8, 0xf4, 0x96, 0xd2, 0x22, 0x1d, 0xd6, 0x62, 0xaf, 0xad, 0xd5, 0x24,
  0xf8, 0x00, 0xcc, 0x49, 0x0d, 0x1a, 0x42, 0xb0, 0x29, 0xc4, 0x9a, 0x3c,
  0xd9, 0x36, 0x58, 0x48, 0xec, 0xd4, 0xdd, 0x23, 0x53, 0x66, 0x4a, 0x47,
  0xfa, 0xb0, 0xa5, 0x18, 0xb6, 0x9c, 0xf1, 0x7a, 0x8f, 0x4e, 0xc2, 0x23,
  0x98, 0x45, 0xec, 0xfd, 0x86, 0x83, 0x7d, 0x60, 0x8d, 0x67, 0x4e, 0x58,
  0x62, 0x42, 0x2d, 0x85, 0x88, 0xc3, 0x9e, 0xb2, 0xc3, 0x60, 0xbb, 0x80,
  0xdb, 0x90, 0x18, 0x25, 0xf0, 0x61, 0x2f, 0xf4, 0x56, 0xc6, 0xdb, 0x26,
  0x76, 0x1c, 0xdf, 0x67, 0x6f, 0x5f, 0x04, 0x1b, 0xf7, 0x33, 0xd1, 0xc8,
  0xef, 0xdc, 0x63, 0x8a, 0x53, 0x9e, 0x4b, 0x3b, 0xd8, 0x77, 0x4c, 0xfe,
  0x1b, 0xfb, 0xa5, 0xe9, 0x4d, 0x77, 0xd3, 0x60, 0xe0, 0x96, 0xed, 0x8a,
  0x42, 0xd7, 0xeb, 0x25, 0x56, 0x38, 0x17, 0x67, 0xd5, 0xed, 0xa8, 0x62,
  0x16, 0x14, 0x8d, 0x30, 0xac, 0xbf, 0xae, 0xac, 0x13, 0x79, 0xb8, 0x9e,
  0xe5, 0xbe, 0x2d, 0xc5, 0x12, 0xb3, 0x99, 0x9d, 0xc3, 0x2b, 0x38, 0x81,
  0x67, 0xcf, 0xea, 0xf5, 0x9b, 0x93, 0x5b, 0x78, 0x72, 0x7a, 0xea, 0x7b,
  0xf8, 0x54, 0x64, 0xd4, 0xcd, 0xbf, 0x6f, 0x6f, 0x0e, 0xe0, 0x61, 0x13,
  0x3a, 0x6d, 0x11, 0xc3, 0x98, 0xec, 0x24, 0x56, 0xe9, 0x26, 0xfa, 0xcd,
  0xb7, 0xb7, 0x41, 0x86, 0x7a, 0x70, 0x88, 0x82, 0xf6, 0x53, 0x95, 0xe4,
  0x45, 0x8a, 0x28, 0x62, 0xbb, 0x7d, 0xb4, 0x5c, 0x60, 0x3d, 0xd7, 0x10,
  0x1b, 0xe7, 0x65, 0xd4, 0x3c, 0x2e, 0x01, 0x2f, 0xac, 0xed, 0xe2, 0xb9,
  0x66, 0xfc, 0x81, 0xda, 0xde, 0xb6, 0xb2, 0xc3, 0xec, 0xd4, 0x8e, 0xc4,
  0x7c, 0x49, 0x2d, 0x21, 0x1d, 0xcd, 0xa9, 0x5f, 0x47, 0x35, 0x5e, 0xcf,
  0x57, 0xa0, 0x69, 0xfc, 0xe2, 0xac, 0xd7, 0xf0, 0x9f, 0x1a, 0x45, 0x9d,
  0x4b, 0x22, 0x79, 0xca, 0x1a, 0x55, 0x70, 0xfd, 0xa3, 0xd3, 0x14, 0x30,
  0x51, 0xad, 0xd9, 0xdf, 0x2d, 0x45, 0xaf, 0x95, 0xc2, 0x66, 0x28, 0xd4,
  0x94, 0xf4, 0xba, 0xcc, 0x69, 0xd4, 0x4e, 0xb1, 0xd3, 0x12, 0xd3, 0xe8,
  0x49, 0x20, 0xcf, 0x3f, 0x6a, 0xb3, 0xa7, 0x2b, 0xed, 0x82, 0xd5, 0xcc,
  0x69, 0x16, 0xd2, 0xdb, 0xd1, 0x07, 0x1f, 0x49, 0xa0, 0x49, 0xbe, 0x76,
  0x28, 0x28, 0xfb, 0xe0, 0x48, 0x6c, 0x7c, 0x1d, 0xa8, 0xfb, 0x44, 0xce,
  0xf7, 0x3b, 0x5c, 0x03, 0xcd, 0x08, 0xf5, 0x86, 0xcf, 0x9d, 0x7f, 0xbc,
  0xa1, 0xbd, 0xdb, 0xd0, 0xe3, 0x50, 0xb6, 0x33, 0x47, 0x5b, 0x01, 0xad,
  0x90, 0xf2, 0x2f, 0x86, 0x6d, 0xf2, 0x57, 0x2f, 0x53, 0xf0, 0x6f, 0x4c,
  0x0f, 0xe5, 0x6c, 0x1a, 0x1f, 0x1a, 0xa6, 0x57, 0x65, 0xe4, 0x75, 0x88,
  0xc3, 0xf6, 0x7c, 0x90, 0x86, 0x36, 0xbf, 0xa2, 0x40, 0x03, 0x4a, 0xcd,
  0xf9, 0x17, 0x35, 0xa1, 0x42, 0x69, 0xde, 0x69, 0x95, 0x2f, 0x09, 0xef,
  0xe6, 0xd6, 0xb5, 0xec, 0x32, 0x44, 0x41, 0x2b, 0x2f, 0x86, 0x02, 0xbe,
  0x83, 0x86, 0xfe, 0x10, 0xc4, 0xe1, 0x61, 0x68, 0xf6, 0x3e, 0x64, 0xb7,
  0x77, 0x23, 0x6e, 0xe3, 0xb2, 0x1c, 0xa7, 0x5b, 0x6e, 0x92, 0xb1, 0x8e,
  0x6f, 0x67, 0x4d, 0x5b, 0xf1, 0x32, 0x37, 0xf3, 0x52, 0x35, 0x74, 0x52,
  0x6f, 0xc4, 0xd0, 0x44, 0x97, 0x60, 0x24, 0xfa, 0x2f, 0xcb, 0xc1, 0xa2,
  0xec, 0x4c, 0xbe, 0x51, 0x6d, 0xf6, 0xba, 0xd7, 0x42, 0x6e, 0xba, 0x49,
  0xd2, 0xe5, 0x08, 0xb1, 0xf7, 0x7d, 0xe6, 0x35, 0x4a, 0x0f, 0x36, 0xdd,
  0x3a, 0xa0, 0x9d, 0x64, 0x75, 0x76, 0x72, 0xef, 0x9d, 0x7f, 0x51, 0xc6,
  0x5d, 0xd5, 0x71, 0x9b, 0x48, 0xd5, 0xdc, 0xe3, 0x71, 0x2a, 0xaa, 0x5a,
  0x61, 0xa9, 0x30, 0x05, 0x4a, 0xf1, 0xd0, 0xa6, 0x20, 0xcd, 0x11, 0xce,
  0xde, 0xa8, 0x39, 0x7c, 0x44, 0x6d, 0x88, 0x19, 0xda, 0x10, 0xce, 0x9b,
  0xf5, 0x45, 0x1a, 0xb1, 0xcf, 0x62, 0x2a, 0x4a, 0x79, 0x9a, 0x3f, 0x7a,
  0xf1, 0x3d, 0x97, 0x39, 0x9e, 0xb2, 0x6b, 0x9d, 0x23, 0x0b, 0x27, 0xae,
  0x35, 0xcc, 0x84, 0xc1, 0xd3, 0x0d, 0x8a, 0x6f, 0x95, 0x5e, 0xb8, 0x47,
  0x3f, 0x22, 0xb6, 0x84, 0x82, 0x09, 0xd3, 0x3c, 0x67, 0x13, 0x95, 0xae,
  0xdb, 0x87, 0xed, 0xb5, 0x94, 0xd1, 0xc1, 0xf3, 0x1b, 0x17, 0xcd, 0x51,
  0xa1, 0x7e, 0xeb, 0x47, 0x52, 0x37, 0xf3, 0x56, 0xc5, 0xda, 0x8b, 0x5b,
  0x66, 0xfa, 0x08, 0x5e, 0x52, 0xcd, 0xe0, 0x95, 0xab, 0x29, 0x88, 0xa3,
  0xa3, 0x9a, 0xa3, 0x2d, 0xb5, 0x9f, 0xe9, 0xd8, 0x7d, 0x05, 0xc9, 0x91,
  0x70, 0xd6, 0xea, 0x52, 0x0d, 0x77, 0x7c, 0x0f, 0xd8, 0x85, 0xfb, 0xc5,
  0xa5, 0xe8, 0x31, 0x40, 0x9f, 0xc3, 0x61, 0x60, 0xc6, 0x57, 0xa5, 0xe6,
  0xdc, 0x34, 0xcc, 0xba, 0xd9, 0x4a, 0xf8, 0x12, 0xb8, 0x97, 0xcb, 0x3e,
  0x7b, 0x74, 0x72, 0x59, 0xe0, 0x15, 0x97, 0xa8, 0x6d, 0xc4, 0xae, 0x24,
  0xba, 0xc9, 0x69, 0x2a, 0xa4, 0x04, 0x95, 0x5b, 0xe0, 0xf4, 0x5f, 0xe2,
  0x80, 0x77, 0xc2, 0xb0, 0xd6, 0x40, 0xd9, 0x69, 0x30, 0x76, 0xd7, 0x44,
  0x83, 0xbf, 0x3b, 0x3e, 0x50, 0x0a, 0xdb, 0xf4, 0x86, 0xe6, 0x11, 0xa9,
  0x98, 0x11, 0x5a, 0x65, 0xb4, 0xad, 0xdb, 0xdf, 0x13, 0x51, 0xdd, 0xc6,
  0xfe, 0xdd, 0x47, 0xc8, 0xff, 0x34, 0x06, 0x5f, 0x7d, 0x1c, 0xbb, 0x39,
  0x98, 0x1d, 0x9b, 0x7c, 0xb2, 0xa0, 0x21, 0xb6, 0x66, 0x46, 0xb3, 0x77,
  0xb2, 0x31, 0x85, 0x2d, 0xb2, 0x59, 0x3b, 0x4e, 0xb6, 0x33, 0x35, 0xef,
  0x64, 0x6c, 0xef, 0xe7, 0x55, 0xf8, 0x9c, 0xe9, 0xb9, 0x62, 0x87, 0x5a,
  0xb7, 0x0e, 0x35, 0x59, 0x29, 0x3f, 0x37, 0x26, 0x08, 0x86, 0xdf, 0x3b,
  0xde, 0x14, 0x2f, 0xe3, 0x47, 0x3e, 0xd5, 0xbe, 0x8a, 0xe6, 0x01, 0xc0,
  0xe4, 0x49, 0x82, 0xc6, 0x4c, 0x73, 0x29, 0xd7, 0x31, 0x7c, 0xc2, 0x89,
  0x52, 0x96, 0x22, 0x8a, 0x0b, 0xe4, 0xa1, 0x6f, 0x52, 0x2b, 0x91, 0xa5,
  0x6a, 0x15, 0xab, 0xcc, 0x7f, 0xe5, 0x9c, 0x42, 0x69, 0xad, 0xe8, 0x32,
  0xc5, 0x67, 0xa7, 0xeb, 0x49, 0x7f, 0x03, 0xc4, 0xd0, 0x53, 0xaf, 0x88,
  0x0f, 0x00, 0x00
};
#define index_htm_gz_len 241
const uint8_t index_htm_gz[] PROGMEM {
  0x1f, 0x8b, 0x08, 0x08, 0xd6, 0x40, 0x5f, 0x5a, 0x00, 0x03, 0x69, 0x6e,
  0x64, 0x65, 0x78, 0x2e, 0x68, 0x74, 0x6d, 0x00, 0x4d, 0x50, 0x3d, 0x4f,
  0x03, 0x31, 0x0c, 0x9d, 0xdb, 0x5f, 0x91, 0x66, 0xe6, 0x88, 0x80, 0x85,
  0x21, 0xb9, 0x05, 0x3a, 0xb7, 0x12, 0x2c, 0x8c, 0x6e, 0xe2, 0x12, 0x97,
  0x5c, 0xee, 0x14, 0x9b, 0x3b, 0xf5, 0xdf, 0x93, 0x5e, 0x90, 0x60, 0x7a,
  0x7e, 0x1f, 0x7e, 0x92, 0x6d, 0x77, 0xaf, 0x87, 0x97, 0xf7, 0x8f, 0xe3,
  0x5e, 0x45, 0x19, 0x52, 0xbf, 0xb5, 0x37, 0x50, 0x09, 0xf2, 0xa7, 0xd3,
  0x98, 0x75, 0xbf, 0xdd, 0xd8, 0x88, 0x10, 0x2a, 0x6e, 0xec, 0x80, 0x02,
  0xca, 0x47, 0x28, 0x8c, 0xe2, 0xf4, 0xb7, 0x9c, 0xbb, 0x67, 0xfd, 0x67,
  0x64, 0x18, 0xd0, 0xe9, 0x99, 0x70, 0x99, 0xc6, 0x22, 0x5a, 0xf9, 0x31,
  0x0b, 0xe6, 0x1a, 0x5c, 0x28, 0x48, 0x74, 0x01, 0x67, 0xf2, 0xd8, 0xad,
  0xe4, 0x4e, 0x51, 0x26, 0x21, 0x48, 0x1d, 0x7b, 0x48, 0xe8, 0x1e, 0x5a,
  0x4d, 0xa2, 0xfc, 0xa5, 0x0a, 0x26, 0xa7, 0x59, 0xae, 0x09, 0x39, 0x22,
  0xd6, 0x9e, 0x58, 0xf0, 0xec, 0xf4, 0x09, 0x18, 0x3d, 0x0c, 0xd3, 0xbd,
  0x67, 0x6e, 0x69, 0xf6, 0x85, 0x26, 0x51, 0x5c, 0xfc, 0x3f, 0xf7, 0xc2,
  0x5a, 0xf5, 0xd6, 0x34, 0x6f, 0x8d, 0x09, 0x49, 0xc2, 0x7e, 0xff, 0x76,
  0x7c, 0x7a, 0xb4, 0xa6, 0x91, 0x7a, 0x93, 0xf9, 0x3d, 0xca, 0x9e, 0xc6,
  0x70, 0x55, 0x14, 0x6a, 0x45, 0x1d, 0x5a, 0x71, 0xa0, 0x79, 0x55, 0x96,
  0x02, 0xd3, 0x84, 0xa5, 0x89, 0xa6, 0xaa, 0xeb, 0xe2, 0x2d, 0x57, 0xdf,
  0x64, 0xda, 0xbb, 0x7e, 0x00, 0xaf, 0x47, 0x4a, 0xd0, 0x3f, 0x01, 0x00,
  0x00
};
#define logo_svg_gz_len 386
const uint8_t logo_svg_gz[] PROGMEM {
  0x1f, 0x8b, 0x08, 0x08, 0xd6, 0x40, 0x5f, 0x5a, 0x00, 0x03, 0x6c, 0x6f,
  0x67, 0x6f, 0x2e, 0x73, 0x76, 0x67, 0x00, 0xad, 0x52, 0xcb, 0x6e, 0x83,
  0x30, 0x10, 0xbc, 0xf7, 0x2b, 0x2c, 0xe7, 0xd2, 0x1e, 0xbc, 0xf8, 0x45,
  0x80, 0x2a, 0xce, 0xa1, 0xe7, 0xf4, 0x23, 0xd2, 0xf0, 0x72, 0x6b, 0x20,
  0x02, 0x37, 0x44, 0xfd, 0xfa, 0xae, 0x4d, 0x93, 0x2a, 0x51, 0x8f, 0x95,
  0xc5, 0xc2, 0xac, 0xd7, 0x63, 0x76, 0x66, 0x37, 0xd3, 0xa9, 0x21, 0xe7,
  0xce, 0xf5, 0x93, 0xa1, 0xad, 0xf7, 0xc7, 0xe7, 0x24, 0x99, 0xe7, 0x19,
  0x66, 0x05, 0xc3, 0xd8, 0x24, 0x92, 0x73, 0x9e, 0x60, 0x05, 0x25, 0x27,
  0x5b, 0xcd, 0x2f, 0xc3, 0xd9, 0x50, 0x4e, 0x38, 0xc9, 0x21, 0x0d, 0x0f,
  0xdd, 0x6e, 0x1a, 0x52, 0x5b, 0xe7, 0xd8, 0xf8, 0xe9, 0x2a, 0x43, 0xab,
  0x53, 0xd5, 0x0f, 0x65, 0x89, 0xe9, 0xe3, 0xde, 0xb7, 0x71, 0xc7, 0xd0,
  0xb1, 0x2a, 0x29, 0x29, 0x0d, 0x7d, 0x65, 0x52, 0x43, 0x46, 0xd2, 0x03,
  0x28, 0x06, 0x05, 0xac, 0x99, 0x40, 0x24, 0x10, 0x48, 0x24, 0xe4, 0x0c,
  0x64, 0x00, 0xc8, 0x2b, 0xc3, 0x82, 0x8c, 0x29, 0xa2, 0x30, 0x0a, 0xc8,
  0x09, 0xff, 0xa2, 0xc9, 0x0d, 0xe5, 0xaa, 0xae, 0xf9, 0x2f, 0xa7, 0x24,
  0x6b, 0x10, 0x07, 0x10, 0x0c, 0x52, 0x64, 0x13, 0x24, 0x9e, 0x12, 0x0b,
  0x29, 0xde, 0x01, 0x8a, 0x04, 0x88, 0x0b, 0xd2, 0x78, 0xa7, 0xc4, 0x9a,
  0x85, 0x32, 0x69, 0x6e, 0x68, 0xfb, 0xa1, 0xaf, 0x28, 0x99, 0xfc, 0x38,
  0x7c, 0x60, 0x33, 0x2b, 0x6c, 0xfd, 0x82, 0x98, 0xb3, 0x7d, 0xf5, 0x3e,
  0xd8, 0xde, 0xd0, 0x37, 0x6c, 0xd2, 0x5d, 0xf3, 0x9d, 0xf5, 0xd5, 0xe8,
  0x2c, 0xbe, 0x0c, 0x55, 0xa0, 0xaf, 0xf9, 0xd9, 0x96, 0xbe, 0x35, 0x54,
  0x70, 0x14, 0x69, 0xf9, 0x51, 0xa5, 0x04, 0x48, 0x26, 0x41, 0xb5, 0x45,
  0xd6, 0x31, 0xad, 0x51, 0x80, 0xac, 0x00, 0xe9, 0x98, 0x8e, 0x62, 0xea,
  0x4e, 0x73, 0x4c, 0xe5, 0xd8, 0xb3, 0xfb, 0xc9, 0x50, 0xe2, 0xc7, 0x7d,
  0x3f, 0xd5, 0xc3, 0xd8, 0x19, 0xda, 0xed, 0xfd, 0x68, 0xcf, 0x8f, 0xc0,
  0x73, 0x15, 0xf5, 0x22, 0xc0, 0x0b, 0x5d, 0x68, 0xfc, 0xc8, 0x20, 0x7b,
  0xba, 0xd3, 0xe7, 0xff, 0x1b, 0xb9, 0xb4, 0x91, 0xa3, 0xda, 0x19, 0xac,
  0x5b, 0x96, 0x3b, 0xc9, 0xb0, 0x8e, 0x84, 0x18, 0x3c, 0xc3, 0x78, 0xef,
  0xd2, 0xd5, 0x78, 0x1d, 0x0f, 0xe9, 0x9d, 0x0c, 0xf6, 0xbb, 0x60, 0x83,
  0x44, 0x94, 0x06, 0xf4, 0xb7, 0xb3, 0x7f, 0x8c, 0x54, 0x24, 0x8a, 0x04,
  0x2d, 0x12, 0xec, 0x52, 0xf4, 0x1c, 0xb5, 0xc3, 0xe1, 0x40, 0x55, 0x17,
  0x2f, 0x71, 0x4a, 0xb7, 0x0f, 0xdf, 0xf2, 0x98, 0xa6, 0x62, 0xce, 0x02,
  0x00, 0x00
};
