/*
 * Decompiled with CFR 0.152.
 */
package co.gongzh.procbridge;

import co.gongzh.procbridge.Encoder;
import co.gongzh.procbridge.ProcBridgeException;
import co.gongzh.procbridge.Protocol;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

final class RequestEncoder
extends Encoder {
    @NotNull
    private final String api;
    @Nullable
    private final JSONObject body;

    RequestEncoder(@NotNull String api, @Nullable JSONObject body) {
        if (api.isEmpty()) {
            throw new IllegalArgumentException("api cannot be empty");
        }
        this.api = api;
        this.body = body;
    }

    @Override
    byte[] encode() throws ProcBridgeException {
        JSONObject obj = new JSONObject();
        obj.put("api", (Object)this.api);
        if (this.body != null) {
            obj.put("body", (Object)this.body);
        } else {
            obj.put("body", (Object)new JSONObject());
        }
        String jsonText = obj.toString();
        try {
            return jsonText.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcBridgeException(e);
        }
    }

    @Override
    Protocol.StatusCode getStatusCode() {
        return Protocol.StatusCode.REQUEST;
    }
}

