/*
 * Decompiled with CFR 0.152.
 */
package org.lackmann.mme.tools;

import co.gongzh.procbridge.ProcBridge;
import co.gongzh.procbridge.ProcBridgeException;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.lackmann.mme.tools.MulticastPublisher;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.EMessageBody;
import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.Integer32;
import org.openmuc.jsml.structures.Integer64;
import org.openmuc.jsml.structures.Integer8;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SmlFile;
import org.openmuc.jsml.structures.SmlList;
import org.openmuc.jsml.structures.SmlListEntry;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.structures.SmlTime;
import org.openmuc.jsml.structures.SmlValue;
import org.openmuc.jsml.structures.Unsigned16;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.Unsigned64;
import org.openmuc.jsml.structures.Unsigned8;
import org.openmuc.jsml.structures.requests.SmlPublicOpenReq;
import org.openmuc.jsml.structures.responses.SmlGetListRes;
import org.openmuc.jsml.transport.SerialReceiver;

public class SmlToJSONMulticast {
    protected static OctetString client_id = null;
    protected static OctetString server_id = null;
    private static SmlTime actSensorTime = null;
    private static int power = -1;
    private static int energy_01 = -1;
    private static int energy_02 = -1;
    private static int energy_00 = -1;
    private static String applied_method = "I-INFO";
    private static boolean hasExtendedRecord = false;
    private static String USBDevice = null;
    private static int retries;
    private static SerialReceiver receiver;
    private static SerialPort port;
    private static int IPC_Port;
    private static String IPC_Peer;
    private static int IPC_Timeout;
    private static ProcBridge IPC_pb;
    private static int MC_Port;
    private static String MC_Address;
    private static MulticastPublisher MC_Publisher;
    private static String REST_url;
    private static int waitTime;
    private static boolean artificialData;
    private static Random randomGenerator;
    private static int artificialTimestamp;

    static {
        receiver = null;
        port = null;
        IPC_Port = -1;
        IPC_Peer = "127.0.0.1";
        IPC_Timeout = 10000;
        IPC_pb = null;
        MC_Port = -1;
        MC_Address = "224.0.113.0";
        MC_Publisher = null;
        REST_url = null;
        waitTime = 60;
        artificialData = false;
        randomGenerator = null;
        artificialTimestamp = 1;
    }

    public static void main(String[] args) throws IOException, PortInUseException, UnsupportedCommOperationException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SmlToJSONMulticast.shutdownClient();
            }
        });
        if (!SmlToJSONMulticast.processCommandLine(args)) {
            System.exit(1);
        }
        if (IPC_Port > 0) {
            IPC_pb = new ProcBridge(IPC_Peer, IPC_Port, (long)IPC_Timeout);
            System.err.println("Running IPC with '" + IPC_Peer + ":" + IPC_Port + "' ");
        }
        if (MC_Port > 0) {
            try {
                MC_Publisher = new MulticastPublisher(MC_Address, MC_Port);
                System.err.println("Running Multicast Publishing to '" + MC_Address + ":" + MC_Port + "' ");
            }
            catch (Exception ex) {
                System.err.println("Fehler beim Initialisieren des MultiCast-Publishers f\u00fcr '" + MC_Address + ":" + MC_Port + "' ");
                System.err.println("Details: '" + ex.getLocalizedMessage() + "'");
                MC_Publisher = null;
            }
        }
        if (REST_url != null) {
            System.err.println("Running REST with '" + REST_url + "' ");
        }
        boolean ParseSuccess = false;
        if (artificialData) {
            randomGenerator = new Random();
            energy_00 = 1000;
            server_id = new OctetString("ARTIFICIAL");
            applied_method = "ARTIFICIAL";
            actSensorTime = null;
            hasExtendedRecord = true;
        }
        while (true) {
            ParseSuccess = false;
            if (artificialData) {
                SmlToJSONMulticast.createArtificialReading();
                ParseSuccess = true;
            } else if (SmlToJSONMulticast.openDevice()) {
                int r = 0;
                while (r < retries) {
                    try {
                        SmlToJSONMulticast.parseSML();
                        ParseSuccess = true;
                        break;
                    }
                    catch (IOException ex) {
                        System.err.println("Error while reading device '" + USBDevice + "'");
                        System.err.println("Details: '" + ex.getLocalizedMessage() + "'");
                        ++r;
                    }
                }
                SmlToJSONMulticast.closeDevice();
            } else {
                System.err.println("Device '" + USBDevice + "' not ready");
            }
            if (ParseSuccess) {
                SmlToJSONMulticast.processSMLReading();
            }
            try {
                TimeUnit.SECONDS.sleep(waitTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private static boolean openDevice() {
        boolean status = false;
        int openRetries = 3;
        int openRetryWaitTime = 1;
        int r = 0;
        while (r < openRetries) {
            try {
                port = (SerialPort)CommPortIdentifier.getPortIdentifier((String)USBDevice).open("SML_USB", 2000);
                receiver = new SerialReceiver(port);
                status = true;
                break;
            }
            catch (IOException ex) {
                System.err.println("Unable to open device '" + USBDevice + "'");
                System.err.println("Details: '" + ex.getLocalizedMessage() + "'");
            }
            catch (NoSuchPortException ex) {
                System.err.println("Device '" + USBDevice + "' not existing");
                System.err.println("Details: '" + ex.getLocalizedMessage() + "'");
            }
            catch (PortInUseException ex) {
                System.err.println("Device '" + USBDevice + "' already in use");
                System.err.println("Details: '" + ex.getLocalizedMessage() + "'");
            }
            try {
                TimeUnit.SECONDS.sleep(openRetryWaitTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
            ++r;
        }
        return status;
    }

    private static void closeDevice() {
        if (port != null) {
            port.close();
        }
        if (receiver != null) {
            try {
                receiver.closeStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void processSMLReading() {
        String jsonMeterReading = SmlToJSONMulticast.writeAsJsonToString();
        if (IPC_Port > 0) {
            try {
                JSONObject resp = IPC_pb.request("metering", jsonMeterReading);
                System.err.println(resp);
            }
            catch (ProcBridgeException e) {
                System.err.println(e.getMessage());
            }
        }
        if (REST_url != null) {
            try {
                SmlToJSONMulticast.SendToRESTUrl(jsonMeterReading);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        if (IPC_Port <= 0 && REST_url == null && MC_Publisher == null) {
            System.out.println(jsonMeterReading);
        }
        if (MC_Publisher != null) {
            System.err.println("Send Multicast");
            MC_Publisher.publish(jsonMeterReading);
        }
    }

    private static void SendToRESTUrl(String jsonMeterReading) throws ClientProtocolException, IOException {
        HttpResponse response = Request.Post((String)REST_url).useExpectContinue().version(HttpVersion.HTTP_1_1).bodyString(jsonMeterReading, ContentType.DEFAULT_TEXT).execute().returnResponse();
        System.err.println(response.getStatusLine());
    }

    protected static void shutdownClient() {
        System.err.println("Shutdown Client ...");
        IPC_pb = null;
        try {
            MC_Publisher.shutdown();
        }
        catch (Throwable ex) {
            System.err.println("Unable to shutdown Multicast Publisher");
            System.err.println("Error: '" + ex.getLocalizedMessage() + "'");
        }
        MC_Publisher = null;
        System.err.println("Done");
    }

    private static void parseSML() throws IOException {
        power = -1;
        energy_00 = -1;
        energy_01 = -1;
        energy_02 = -1;
        SmlFile smlFile = receiver.getSMLFile();
        List smlMessages = smlFile.getMessages();
        int i = 0;
        while (i < smlMessages.size()) {
            SmlMessage sml_message = (SmlMessage)smlMessages.get(i);
            EMessageBody tag = EMessageBody.toEnum((int)sml_message.getMessageBody().getTag().getVal());
            switch (tag) {
                case OPEN_REQUEST: {
                    SmlPublicOpenReq sml_PublicOpenReq = (SmlPublicOpenReq)sml_message.getMessageBody().getChoice();
                    client_id = sml_PublicOpenReq.getClientId();
                    break;
                }
                case OPEN_RESPONSE: {
                    break;
                }
                case CLOSE_REQUEST: {
                    System.err.println("Got CloseRequest");
                    break;
                }
                case CLOSE_RESPONSE: {
                    break;
                }
                case GET_PROFILE_PACK_REQUEST: {
                    System.err.println("Got GetProfilePackRequest");
                    break;
                }
                case GET_PROFILE_PACK_RESPONSE: {
                    System.err.println("Got GetProfilePackResponse");
                    break;
                }
                case GET_PROFILE_LIST_REQUEST: {
                    System.err.println("Got GetProfileListRequest");
                    break;
                }
                case GET_PROFILE_LIST_RESPONSE: {
                    System.err.println("Got GetProfileListResponse");
                    break;
                }
                case GET_PROC_PARAMETER_REQUEST: {
                    System.err.println("Got GetProcParameterRequest");
                    break;
                }
                case GET_PROC_PARAMETER_RESPONSE: {
                    System.err.println("Got GetProcParameterResponse");
                    break;
                }
                case SET_PROC_PARAMETER_REQUEST: {
                    System.err.println("Got SetProcParameterRequest");
                    break;
                }
                case SET_PROC_PARAMETER_RESPONSE: {
                    System.err.println("Got SetProcParameterResponse");
                    break;
                }
                case GET_LIST_REQUEST: {
                    System.err.println("Got GetListRequest");
                    break;
                }
                case GET_LIST_RESPONSE: {
                    SmlListEntry[] list;
                    SmlGetListRes resp = (SmlGetListRes)sml_message.getMessageBody().getChoice();
                    server_id = resp.getServerId();
                    actSensorTime = resp.getActSensorTime();
                    SmlList smlList = resp.getValList();
                    SmlListEntry[] smlListEntryArray = list = smlList.getValListEntry();
                    int n = list.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SmlListEntry entry = smlListEntryArray[n2];
                        if (entry.getUnit().getVal() == 30 || entry.getUnit().getVal() == 27) {
                            SmlValue sml_value = entry.getValue();
                            ASNObject obj = sml_value.getChoice();
                            int value = 0;
                            if (obj.getClass().equals(Integer8.class)) {
                                value = ((Integer8)obj).getVal();
                            } else if (obj.getClass().equals(Integer16.class)) {
                                value = ((Integer16)obj).getVal();
                            } else if (obj.getClass().equals(Integer32.class)) {
                                value = ((Integer32)obj).getVal();
                            } else if (obj.getClass().equals(Integer64.class)) {
                                value = (int)((Integer64)obj).getVal();
                            } else if (obj.getClass().equals(Unsigned8.class)) {
                                value = ((Unsigned8)obj).getVal();
                            } else if (obj.getClass().equals(Unsigned16.class)) {
                                value = ((Unsigned16)obj).getVal();
                            } else if (obj.getClass().equals(Unsigned32.class)) {
                                value = ((Unsigned32)obj).getVal();
                            } else if (!obj.getClass().equals(Unsigned64.class)) {
                                obj.getClass().equals(OctetString.class);
                            }
                            if (entry.getUnit().getVal() == 30) {
                                if (entry.getObjName().toString().equals("01 00 01 08 00 FF")) {
                                    energy_01 = value;
                                } else if (entry.getObjName().toString().equals("01 00 02 08 00 FF")) {
                                    energy_02 = value;
                                } else {
                                    energy_00 = value;
                                }
                            } else {
                                power = value;
                                hasExtendedRecord = true;
                            }
                        }
                        ++n2;
                    }
                    break;
                }
                case ATTENTION_RESPONSE: {
                    System.err.println("Got AttentionResponse");
                    break;
                }
                default: {
                    System.err.println("type not found");
                }
            }
            ++i;
        }
    }

    private static void createArtificialReading() {
        power = randomGenerator.nextInt(100) + 100;
        energy_00 += power * waitTime / 360;
        energy_01 = -1;
        energy_02 = -1;
        artificialTimestamp += waitTime;
    }

    private static boolean processCommandLine(String[] args) {
        String[] parts;
        String opStr;
        OptionParser parser = new OptionParser();
        OptionSet options = null;
        parser.accepts("retries").withRequiredArg().ofType(Integer.class);
        parser.accepts("device").withRequiredArg().ofType(String.class);
        parser.accepts("ipc").withRequiredArg().ofType(String.class);
        parser.accepts("wait").withRequiredArg().ofType(Integer.class);
        parser.accepts("rest").withRequiredArg().ofType(String.class);
        parser.accepts("mc").withRequiredArg().ofType(String.class);
        try {
            options = parser.parse(args);
        }
        catch (OptionException ex) {
            System.err.println("Error in reading command line: '" + ex.getLocalizedMessage() + "'");
            return false;
        }
        boolean result = true;
        if (options.has("wait") && options.hasArgument("wait")) {
            waitTime = (Integer)options.valueOf("wait");
        }
        if (options.has("retries") && options.hasArgument("retries")) {
            retries = (Integer)options.valueOf("retries");
        }
        if (options.has("device") && options.hasArgument("device") && (USBDevice = (String)options.valueOf("device")).equals("random")) {
            artificialData = true;
        }
        if (options.has("ipc") && options.hasArgument("ipc")) {
            opStr = (String)options.valueOf("ipc");
            if (opStr.indexOf(58) >= 0) {
                parts = opStr.split(":");
                if (parts.length != 2) {
                    System.err.println("\nInvalid value for IPC-option: " + opStr + "\n");
                    IPC_Port = -1;
                    result = false;
                } else {
                    IPC_Peer = parts[0];
                    IPC_Port = Integer.parseInt(parts[1]);
                }
            } else {
                IPC_Port = Integer.parseInt(opStr);
            }
            if (IPC_Port <= 1000 || IPC_Port >= 100000) {
                System.err.println("\nUInvalid value for IPC-port: " + IPC_Port + "\n");
                IPC_Port = -1;
                result = false;
            }
        }
        if (options.has("mc") && options.hasArgument("mc")) {
            opStr = (String)options.valueOf("mc");
            if (opStr.indexOf(58) >= 0) {
                parts = opStr.split(":");
                if (parts.length != 2) {
                    System.err.println("\nInvalid value for MultiCast-Option: " + opStr + "\n");
                    MC_Port = -1;
                    result = false;
                } else {
                    MC_Address = parts[0];
                    MC_Port = Integer.parseInt(parts[1]);
                }
            } else {
                MC_Port = Integer.parseInt(opStr);
            }
            if (MC_Port <= 1000 || MC_Port >= 100000) {
                System.err.println("\nInvalid value for MultiCast-Port: " + MC_Port + "\n");
                MC_Port = -1;
                result = false;
            }
        }
        if (options.has("rest") && options.hasArgument("rest")) {
            REST_url = (String)options.valueOf("rest");
        }
        if (USBDevice == null) {
            System.err.println("\nUSB input device option '-device' not set!\n");
            result = false;
        }
        if (retries <= 0 && !artificialData) {
            System.err.println("\nNumber of retries option '-retries' not set!\n");
            result = false;
        }
        return result;
    }

    private static String writeAsJsonToString() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Instant instant = timestamp.toInstant();
        float value_00 = -1.0f;
        float value_01 = -1.0f;
        float value_02 = -1.0f;
        if (hasExtendedRecord) {
            if (energy_00 > -1) {
                value_00 = (float)energy_00 / 10000.0f;
            }
            if (energy_01 > -1) {
                value_01 = (float)energy_01 / 10000.0f;
            }
            if (energy_02 > -1) {
                value_02 = (float)energy_02 / 10000.0f;
            }
            if (value_00 == -1.0f && value_01 > 0.0f) {
                value_00 = value_01;
                value_01 = -1.0f;
            }
        } else {
            value_00 = (float)energy_01 / 10000.0f;
        }
        String meterReading = String.format(Locale.ROOT, "{'applied_method': '%s', 'server_id': '%s', 'reading_date': '%s', 'timestamp': %d, 'value': %.4f, 'value_01': %.4f, 'value_02': %.4f, 'power': %d}", applied_method, server_id.toHexString(), instant.toString(), artificialData ? artificialTimestamp : ((Unsigned32)actSensorTime.getChoice()).getVal(), Float.valueOf(value_00), Float.valueOf(value_01), Float.valueOf(value_02), power);
        return meterReading;
    }
}

