/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml;

import java.util.List;
import org.openmuc.jsml.structures.EMessageBody;
import org.openmuc.jsml.structures.SmlFile;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.structures.responses.SmlAttentionRes;
import org.openmuc.jsml.structures.responses.SmlGetListRes;
import org.openmuc.jsml.structures.responses.SmlGetProcParameterRes;
import org.openmuc.jsml.structures.responses.SmlGetProfileListRes;
import org.openmuc.jsml.structures.responses.SmlGetProfilePackRes;
import org.openmuc.jsml.structures.responses.SmlPublicCloseRes;
import org.openmuc.jsml.structures.responses.SmlPublicOpenRes;

public class GenericParser {
    private GenericParser() {
    }

    public static void printFile(SmlFile smlFile) {
        List<SmlMessage> smlMessages = smlFile.getMessages();
        for (SmlMessage smlMessage : smlMessages) {
            int tag = smlMessage.getMessageBody().getTag().getVal();
            EMessageBody messageBody = EMessageBody.toEnum(tag);
            switch (messageBody) {
                case OPEN_REQUEST: {
                    GenericParser.parseOpenRequest(smlMessage);
                    break;
                }
                case OPEN_RESPONSE: {
                    GenericParser.parseOpenResponse(smlMessage);
                    break;
                }
                case CLOSE_REQUEST: {
                    GenericParser.parseCloseRequest(smlMessage);
                    break;
                }
                case CLOSE_RESPONSE: {
                    GenericParser.parseCloseResponse(smlMessage);
                    break;
                }
                case GET_PROFILE_PACK_REQUEST: {
                    GenericParser.parseGetProfilePackRequest(smlMessage);
                    break;
                }
                case GET_PROFILE_PACK_RESPONSE: {
                    GenericParser.parseGetProfilePackResponse(smlMessage);
                    break;
                }
                case GET_PROFILE_LIST_REQUEST: {
                    GenericParser.parseGetProfileListRequest(smlMessage);
                    break;
                }
                case GET_PROFILE_LIST_RESPONSE: {
                    GenericParser.parseGetProfileListResponse(smlMessage);
                    break;
                }
                case GET_PROC_PARAMETER_REQUEST: {
                    GenericParser.parseGetProcParameterRequest(smlMessage);
                    break;
                }
                case GET_PROC_PARAMETER_RESPONSE: {
                    GenericParser.parseGetProcParameterResponse(smlMessage);
                    break;
                }
                case SET_PROC_PARAMETER_REQUEST: {
                    GenericParser.parseSetProcParameterRequest(smlMessage);
                    break;
                }
                case GET_LIST_REQUEST: {
                    GenericParser.parseGetListRequest(smlMessage);
                    break;
                }
                case GET_LIST_RESPONSE: {
                    GenericParser.parseGetListResponse(smlMessage);
                    break;
                }
                case ATTENTION_RESPONSE: {
                    GenericParser.parseAttentionResponse(smlMessage);
                    break;
                }
                default: {
                    System.out.println("type not found");
                }
            }
        }
    }

    private static void parseGetListResponse(SmlMessage smlMessage) {
        System.out.println("Got GetListResponse");
        SmlGetListRes sml_listRes = (SmlGetListRes)smlMessage.getMessageBody().getChoice();
        System.out.println(sml_listRes.toStringIndent(" "));
    }

    private static void parseAttentionResponse(SmlMessage smlMessage) {
        System.out.println("Got AttentionResponse");
        SmlAttentionRes sml_attentionRes = (SmlAttentionRes)smlMessage.getMessageBody().getChoice();
        System.out.println(sml_attentionRes.toString());
    }

    private static void parseGetProcParameterResponse(SmlMessage smlMessage) {
        System.out.println("Got GetProcParameterResponse");
        SmlGetProcParameterRes sml_getProcParameterRes = (SmlGetProcParameterRes)smlMessage.getMessageBody().getChoice();
        System.out.println(sml_getProcParameterRes.toString());
    }

    private static void parseGetProfileListResponse(SmlMessage smlMessage) {
        System.out.println("Got GetProfileListResponse");
        SmlGetProfileListRes sml_getProfileListRes = (SmlGetProfileListRes)smlMessage.getMessageBody().getChoice();
        System.out.println(sml_getProfileListRes.toString());
    }

    private static void parseOpenResponse(SmlMessage smlMessage) {
        System.out.println("Got OpenResponse");
        SmlPublicOpenRes sml_PublicOpenRes = (SmlPublicOpenRes)smlMessage.getMessageBody().getChoice();
        System.out.println(sml_PublicOpenRes.toString());
    }

    private static void parseCloseResponse(SmlMessage smlMessage) {
        System.out.println("Got CloseResponse");
        SmlPublicCloseRes sml_PublicCloseRes = (SmlPublicCloseRes)smlMessage.getMessageBody().getChoice();
        System.out.println(sml_PublicCloseRes.toString());
    }

    private static void parseGetProfilePackResponse(SmlMessage smlMessage) {
        System.out.println("Got GetProfilePackResponse");
        SmlGetProfilePackRes sml_getProfilePackRes = (SmlGetProfilePackRes)smlMessage.getMessageBody().getChoice();
        System.out.println(sml_getProfilePackRes.toString());
    }

    private static void parseCloseRequest(SmlMessage smlMessage) {
        System.out.println("Got CloseRequest");
    }

    private static void parseGetProfileListRequest(SmlMessage smlMessage) {
        System.out.println("Got GetProfileListRequest");
    }

    private static void parseGetProfilePackRequest(SmlMessage smlMessage) {
        System.out.println("Got GetProfilePackRequest");
    }

    private static void parseOpenRequest(SmlMessage smlMessage) {
        System.out.println("Got OpenRequest");
    }

    private static void parseGetProcParameterRequest(SmlMessage smlMessage) {
        System.out.println("Got GetProcParameterRequest");
    }

    private static void parseSetProcParameterRequest(SmlMessage smlMessage) {
        System.out.println("Got SetProcParameterRequest");
    }

    private static void parseGetListRequest(SmlMessage smlMessage) {
        System.out.println("Got GetListRequest");
    }
}

