/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.app;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.openmuc.jsml.GenericParser;
import org.openmuc.jsml.app.XTrustProvider;
import org.openmuc.jsml.structures.EMessageBody;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SmlFile;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.structures.SmlMessageBody;
import org.openmuc.jsml.structures.SmlTreePath;
import org.openmuc.jsml.structures.Unsigned8;
import org.openmuc.jsml.structures.requests.SmlGetProfileListReq;
import org.openmuc.jsml.structures.requests.SmlPublicCloseReq;
import org.openmuc.jsml.structures.requests.SmlPublicOpenReq;
import org.openmuc.jsml.transport.TConnection;
import org.openmuc.jsml.transport.TSAP;

public class SampleTcpClient {
    public static void main(String[] args) throws UnknownHostException, IOException {
        if (args.length == 0) {
            System.out.println("Usage: SampleSMLClient portnum [-s]");
            System.exit(1);
        }
        int port = -1;
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid port.");
            System.out.println("Usage: SampleSMLClient portnum [-s]");
            System.exit(1);
        }
        boolean useSSL = false;
        if (args.length > 1) {
            if (args[1].equals("-s")) {
                useSSL = true;
            } else {
                System.out.println("Usage: SampleSMLClient portnum [-s]");
                System.exit(1);
            }
        }
        TSAP sml_tSAP = null;
        if (!useSSL) {
            sml_tSAP = new TSAP();
        } else {
            System.out.println("using ssl");
            XTrustProvider.install();
            SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            sml_tSAP = new TSAP(sslSocketFactory);
        }
        TConnection sml_tConnection = null;
        System.out.println("Trying to connect to port: " + port);
        sml_tConnection = sml_tSAP.connectTo(InetAddress.getByName("localhost"), port, 0);
        System.out.println("Sending a GetProfileListRequest");
        sml_tConnection.send(SampleTcpClient.createGetProfileListRequest(1, 1));
        System.out.println("Listening for an SML response from the server");
        SmlFile smlFile = sml_tConnection.getSMLFile();
        System.out.println("Got a response from the server.");
        GenericParser.printFile(smlFile);
        System.out.println("Disconnecting");
        sml_tConnection.close();
        System.out.println("Client is done and quits");
    }

    public static byte[] createGetProfileListRequest(int groupNumber, int transactionIDCounter) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(50);
        DataOutputStream os = new DataOutputStream(bs);
        OctetString transactionId = new OctetString(("" + transactionIDCounter++).getBytes());
        Unsigned8 groupNum = new Unsigned8(groupNumber++);
        Unsigned8 abortOnError = new Unsigned8(0);
        int iClientId = 16;
        OctetString clientId = new OctetString(("" + iClientId).getBytes());
        int iReqFileId = 17;
        OctetString reqFileId = new OctetString(("" + iReqFileId).getBytes());
        SmlPublicOpenReq openRequest = new SmlPublicOpenReq(null, clientId, reqFileId, null, null, null, null);
        SmlMessageBody smlMessageBody = new SmlMessageBody(EMessageBody.OPEN_REQUEST.id(), openRequest);
        SmlMessage openRequestMessage = new SmlMessage(transactionId, groupNum, abortOnError, smlMessageBody);
        transactionId = new OctetString(("" + transactionIDCounter++).getBytes());
        groupNum = new Unsigned8(groupNumber++);
        SmlTreePath treePath = new SmlTreePath(new OctetString[]{new OctetString("testtreepath".getBytes())});
        SmlGetProfileListReq getProfileListRequest = new SmlGetProfileListReq(null, null, null, null, null, null, treePath, null, null);
        smlMessageBody = new SmlMessageBody(EMessageBody.GET_PROFILE_LIST_REQUEST.id(), getProfileListRequest);
        SmlMessage getProfileListRequestMessage = new SmlMessage(transactionId, groupNum, abortOnError, smlMessageBody);
        transactionId = new OctetString(("" + transactionIDCounter++).getBytes());
        groupNum = new Unsigned8(groupNumber++);
        SmlPublicCloseReq closeRequest = new SmlPublicCloseReq(null);
        smlMessageBody = new SmlMessageBody(EMessageBody.CLOSE_REQUEST.id(), closeRequest);
        SmlMessage closeRequestMessage = new SmlMessage(transactionId, groupNum, abortOnError, smlMessageBody);
        try {
            openRequestMessage.encode(os);
            getProfileListRequestMessage.encode(os);
            closeRequestMessage.encode(os);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return bs.toByteArray();
    }
}

