/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.internal.cli;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.openmuc.jsml.internal.cli.CliParameter;
import org.openmuc.jsml.internal.cli.CliParseException;

public class CliParser {
    private final String name;
    private final String description;
    private String selectedGroup = "";
    private static final String HELP = "--help";
    private final List<ParameterGroup> commandLineParameterGroups = new ArrayList<ParameterGroup>();

    public CliParser(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public void addParameterGroup(String groupName, List<CliParameter> parameters) {
        this.commandLineParameterGroups.add(new ParameterGroup(groupName.toLowerCase(), parameters));
    }

    public void addParameters(List<CliParameter> parameters) {
        this.commandLineParameterGroups.clear();
        this.commandLineParameterGroups.add(new ParameterGroup("", parameters));
    }

    public String getSelectedGroup() {
        return this.selectedGroup;
    }

    public void parseArguments(String[] args) throws CliParseException {
        if (args.length > 0 && HELP.equals(args[0])) {
            System.out.println(this.getUsageString());
            System.exit(0);
        }
        List parameters = null;
        int i = 0;
        if (this.commandLineParameterGroups.get(0).name.isEmpty()) {
            parameters = this.commandLineParameterGroups.get(0).parameters;
        } else {
            if (args.length == 0) {
                throw new CliParseException("No parameters found.");
            }
            for (ParameterGroup parameterGroup : this.commandLineParameterGroups) {
                if (!parameterGroup.name.equals(args[0].toLowerCase())) continue;
                this.selectedGroup = parameterGroup.name;
                parameters = parameterGroup.parameters;
            }
            if (parameters == null) {
                throw new CliParseException("Group name " + args[0] + " is undefined.");
            }
            ++i;
        }
        while (i < args.length) {
            boolean found = false;
            for (CliParameter option : parameters) {
                if (!args[i].equals(option.getName())) continue;
                i += option.parse(args, i);
                found = true;
                break;
            }
            if (found) continue;
            throw new CliParseException("Unknown parameter found: " + args[i]);
        }
        for (CliParameter option : parameters) {
            if (option.isOptional() || option.isSelected()) continue;
            throw new CliParseException("Parameter " + option.getName() + " is mandatory but was not selected.");
        }
    }

    public String getUsageString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NAME\n\t").append(this.name).append(" - ").append(this.description).append("\n\nSYNOPSIS\n");
        for (ParameterGroup parameterGroup : this.commandLineParameterGroups) {
            sb.append("\t").append(this.name).append(" ").append(parameterGroup.name);
            int characterColumn = this.name.length() + parameterGroup.name.length() + 1;
            for (CliParameter parameter : parameterGroup.parameters) {
                if (characterColumn + parameter.appendSynopsis(new StringBuilder()) > 90) {
                    characterColumn = 0;
                    sb.append("\n\t    ");
                }
                sb.append(' ');
                characterColumn += parameter.appendSynopsis(sb) + 1;
            }
            sb.append("\n");
        }
        sb.append("\nOPTIONS\n");
        LinkedHashSet parameters = new LinkedHashSet();
        for (ParameterGroup parameterGroup : this.commandLineParameterGroups) {
            parameters.addAll(parameterGroup.parameters);
        }
        for (CliParameter parameter : parameters) {
            sb.append(' ');
            parameter.appendDescription(sb);
            sb.append("\n\n");
        }
        sb.append("\t--help display this help and exit");
        return sb.toString();
    }

    private static class ParameterGroup {
        private final String name;
        private final List<CliParameter> parameters;

        public ParameterGroup(String name, List<CliParameter> parameters) {
            this.name = name;
            this.parameters = parameters;
        }
    }
}

