/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.ASNObject;

public abstract class ListOf
extends ASNObject {
    protected ASNObject[] seqArray;

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional && !this.isSelected) {
            os.writeByte(1);
            return;
        }
        if (this.seqArray == null || this.seqArray.length < 1) {
            throw new IOException("ListOf contains no elements");
        }
        int numTlField = 1;
        while (Math.pow(2.0, 4 * numTlField) - 1.0 < (double)this.seqArray.length) {
            ++numTlField;
        }
        int i = numTlField;
        while (i > 0) {
            int firstFourBits = i < numTlField ? (i > 1 ? 128 : 0) : (numTlField > 1 ? 240 : 112);
            os.writeByte(firstFourBits & 0xFF | this.seqArray.length >> (i - 1) * 4 & 0xF);
            --i;
        }
        ASNObject[] aSNObjectArray = this.seqArray;
        int n = this.seqArray.length;
        int n2 = 0;
        while (n2 < n) {
            ASNObject element = aSNObjectArray[n2];
            element.encode(os);
            ++n2;
        }
    }

    public ASNObject[] seqArray() {
        return this.seqArray;
    }
}

