/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.transport;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.openmuc.jsml.transport.Crc16;

public class MessageExtractor {
    private final DataInputStream inputStream;
    private final ByteBuffer smlMessageBuffer = ByteBuffer.allocate(100000);
    private byte[] smlMessage = null;
    private int crc = 65535;
    private final byte[] buffer = new byte[8];
    private int bufferEnd = 0;
    private final long timeoutInMillies;
    private boolean startSequenceFound = false;

    public MessageExtractor(DataInputStream inputStream, long timeoutInMillies) throws IOException {
        this.inputStream = inputStream;
        this.timeoutInMillies = timeoutInMillies;
        this.smlMessageBuffer.rewind();
    }

    public byte[] getSmlMessage() throws IOException {
        this.waitForStartSequence();
        this.waitForStopSequence();
        return this.smlMessage;
    }

    private void waitForStartSequence() throws IOException {
        while (!this.startSequenceFound) {
            this.fillBufferWithTimeout();
            if (this.checkForStartSequence()) {
                this.crc = 65535;
                this.clearBuffer();
                this.startSequenceFound = true;
                return;
            }
            this.dropByte();
        }
    }

    private void waitForStopSequence() throws IOException {
        boolean stopSequenceFound = false;
        while (!stopSequenceFound) {
            this.fillBufferWithTimeout();
            if (this.checkForEscapeSequence()) {
                if (this.checkForEscapedEscapeSequence()) {
                    int i = 4;
                    while (i < 8) {
                        this.incrementalCRC(this.buffer[i]);
                        ++i;
                    }
                    this.bufferEnd = 4;
                    this.clearBuffer();
                    continue;
                }
                if (this.checkForStartSequence()) {
                    this.crc = 65535;
                    this.clearBuffer();
                    this.startSequenceFound = true;
                    this.smlMessageBuffer.rewind();
                    continue;
                }
                stopSequenceFound = true;
                byte numStuffBytes = this.buffer[5];
                int i = 0;
                while (i < 6) {
                    this.incrementalCRC(this.buffer[i]);
                    ++i;
                }
                int receivedCRC = (0xFF & this.buffer[6]) * 256 + (0xFF & this.buffer[7]);
                if (this.buffer[4] != 26 || numStuffBytes > 3) {
                    throw new IOException("Termination sequence is wrong");
                }
                this.crc ^= 0xFFFF;
                this.crc = (this.crc & 0xFF) << 8 | (this.crc & 0xFF00) >> 8;
                if (receivedCRC != this.crc) {
                    throw new IOException("wrong crc");
                }
                int bufferLength = this.smlMessageBuffer.position();
                this.smlMessage = new byte[bufferLength - numStuffBytes];
                this.smlMessageBuffer.rewind();
                this.smlMessageBuffer.get(this.smlMessage);
                continue;
            }
            this.incrementalCRC(this.dropByte());
        }
    }

    private void clearBuffer() {
        while (this.bufferEnd > 0) {
            this.incrementalCRC(this.dropByte());
        }
    }

    private byte dropByte() {
        byte droppedByte = this.buffer[0];
        int i = 0;
        while (i < this.bufferEnd - 1) {
            this.buffer[i] = this.buffer[i + 1];
            ++i;
        }
        --this.bufferEnd;
        if (this.startSequenceFound) {
            this.smlMessageBuffer.put(droppedByte);
        }
        return droppedByte;
    }

    private void incrementalCRC(byte msgByte) {
        this.crc = this.crc >> 8 ^ Crc16.TABLE[(this.crc ^ msgByte) & 0xFF];
    }

    private void fillBufferWithTimeout() throws IOException {
        long lastRead = System.currentTimeMillis();
        while (this.bufferEnd < 8) {
            if (System.currentTimeMillis() - lastRead > this.timeoutInMillies) {
                throw new IOException("Timeout");
            }
            if (this.inputStream.available() > 0) {
                this.buffer[this.bufferEnd] = this.inputStream.readByte();
                ++this.bufferEnd;
                lastRead = System.currentTimeMillis();
                continue;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean checkForEscapeSequence() {
        int i = 0;
        while (i < 4) {
            if (this.buffer[i] != 27) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkForEscapedEscapeSequence() {
        int i = 4;
        while (i < 8) {
            if (this.buffer[i] != 27) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkForStartSequence() {
        if (!this.checkForEscapeSequence()) {
            return false;
        }
        int i = 4;
        while (i < 8) {
            if (this.buffer[i] != 1) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

