/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openmuc.jsml.structures.EMessageBody;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SmlFile;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.structures.SmlMessageBody;
import org.openmuc.jsml.structures.Unsigned8;
import org.openmuc.jsml.structures.responses.SmlAttentionRes;
import org.openmuc.jsml.transport.Transport;

public class TConnection {
    private static final Logger LOGGER = Logger.getLogger(TConnection.class.getName());
    private Socket socket;
    private DataOutputStream os;
    private DataInputStream is;

    public TConnection(Socket socket, int messageTimeout, int messageFragmentTimeout) throws IOException {
        this.socket = socket;
        this.os = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.is = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
    }

    public void send(byte[] smlPackage) throws IOException {
        Transport transport = new Transport();
        transport.send(this.os, smlPackage);
    }

    public void sendAttentionResponse(OctetString attentionType, String message, OctetString serverID, SmlMessage faultyMessage) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(50);
        DataOutputStream os = new DataOutputStream(bs);
        Unsigned8 abortOnError = new Unsigned8(0);
        OctetString attentionMsg = null;
        if (message != null) {
            attentionMsg = new OctetString(message.getBytes());
        }
        SmlAttentionRes attentionres = new SmlAttentionRes(serverID, attentionType, attentionMsg, null);
        SmlMessageBody attentionresBody = new SmlMessageBody(EMessageBody.ATTENTION_RESPONSE.id(), attentionres);
        SmlMessage attentionmessage = new SmlMessage(faultyMessage.getTransactionId(), faultyMessage.getGroupNo(), abortOnError, attentionresBody);
        try {
            attentionmessage.encode(os);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "unable to encode attention message", e);
        }
        try {
            this.send(bs.toByteArray());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "unable to send message to client", e);
        }
    }

    public SmlFile getSMLFile() throws IOException {
        Transport transport = new Transport();
        return transport.getSMLFile(this.is);
    }

    public void close() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.os = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.socket != null && this.socket.isBound()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }
}

