/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.SmlFile;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.transport.Crc16;
import org.openmuc.jsml.transport.MessageExtractor;

public class Transport {
    public void send(DataOutputStream os, byte[] smlPackage) throws IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(smlPackage.length + 30);
        DataOutputStream dataByteArrayOutputStream = new DataOutputStream(bs);
        Transport.writeUnsignedInt(dataByteArrayOutputStream, 0x1B1B1B1BL);
        Transport.writeUnsignedInt(dataByteArrayOutputStream, 0x1010101L);
        int numEscapeSeqFound = 0;
        int i = 0;
        while (i < smlPackage.length) {
            if (i >= smlPackage.length - 3) {
                int j = i;
                while (j < smlPackage.length) {
                    dataByteArrayOutputStream.write(smlPackage[j]);
                    ++j;
                }
                break;
            }
            if ((smlPackage[i] & 0xFF) == 27 && (smlPackage[i + 1] & 0xFF) == 27 && (smlPackage[i + 2] & 0xFF) == 27 && (smlPackage[i + 3] & 0xFF) == 27) {
                Transport.writeUnsignedInt(dataByteArrayOutputStream, 0x1B1B1B1BL);
                ++numEscapeSeqFound;
            }
            int k = 0;
            while (k < 4) {
                dataByteArrayOutputStream.writeByte(smlPackage[i + k]);
                ++k;
            }
            i += 4;
        }
        int numStuffBits = 4 - (smlPackage.length + numEscapeSeqFound * 4) % 4;
        if (numStuffBits == 4) {
            numStuffBits = 0;
        }
        int i2 = 0;
        while (i2 < numStuffBits) {
            dataByteArrayOutputStream.writeByte(0);
            ++i2;
        }
        Transport.writeUnsignedInt(dataByteArrayOutputStream, 0x1B1B1B1BL);
        dataByteArrayOutputStream.writeByte(26);
        dataByteArrayOutputStream.writeByte(numStuffBits & 0xFF);
        byte[] packet = bs.toByteArray();
        int crc16 = Crc16.check(packet);
        os.write(packet);
        os.writeShort(crc16 & 0xFFFF);
        os.flush();
        dataByteArrayOutputStream.close();
        bs.close();
    }

    public SmlFile getSMLFile(DataInputStream is) throws IOException {
        MessageExtractor extractor = new MessageExtractor(is, 30000L);
        return this.handleSMLStream(extractor.getSmlMessage());
    }

    private SmlFile handleSMLStream(byte[] smlPacket) throws IOException {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(smlPacket));
        SmlFile smlFile = new SmlFile();
        while (is.available() > 0) {
            SmlMessage message = new SmlMessage();
            if (!message.decode(is)) {
                throw new IOException("Could not decode message");
            }
            smlFile.add(message);
        }
        return smlFile;
    }

    private static void writeUnsignedInt(DataOutputStream os, long value) throws IOException {
        os.writeByte((int)((value & 0xFF000000L) >> 24));
        os.writeByte((int)((value & 0xFF0000L) >> 16));
        os.writeByte((int)((value & 0xFF00L) >> 8));
        os.writeByte((int)(value & 0xFFL));
    }
}

