const int buttons[] = {1, 2, 3, 4};        // Pins für die Taster
const int leds[] = {5, 6, 7, 8};           // Pins für die LEDs
const int speaker = 9;                     // Pin für den Lautsprecher
const int notes[] = {523, 659, 784, 1047}; // Melodienoten: C5, E5, G5, C6

int lastButton = -1;    // Zuletzt gedrückter Taster: 0 - 3 = Index in buttons[], -1 = nichts gedrückt

void setup() {
  for(int i=0; i<4; i++) {
    pinMode(buttons[i], INPUT);
    pinMode(leds[i], OUTPUT);
  } 
  pinMode(speaker, OUTPUT);
}

void loop() {
  // Prüfen, ob eine Taste gedrückt ist
  int currentButton = -1;
  for(int i=0; i<4; i++) {
    if(digitalRead(buttons[i]) == HIGH) {
      currentButton = i;
      break;
    }
  }
  if(currentButton != lastButton) { // Hat sich was geändert?
    if(lastButton != -1) { // Beim letzten Mal war eine Taste gedrückt, jetzt ist sie losgelassen
      digitalWrite(leds[lastButton], LOW);
      noTone(speaker);
      lastButton = -1;
    }
    if(currentButton != -1) { // Eine neue Taste wurde gedrückt
      digitalWrite(leds[currentButton], HIGH);
      tone(speaker, notes[currentButton], 1000);
      lastButton = currentButton;
    }
  }
}
