const int buttons[] = {1, 2, 3, 4};        // Pins für die Taster
const int leds[] = {5, 6, 7, 8};           // Pins für die LEDs
const int speaker = 9;                     // Pin für den Lautsprecher
const int notes[] = {523, 659, 784, 1047}; // Melodienoten: C5, E5, G5, C6

bool guessing = false;  // Betriebszustand: true = Spieler rät, false = Melodie wird vorgespielt
int lastButton = -1;    // Zuletzt gedrückter Taster: 0 - 3 = Index in buttons[], -1 = nichts gedrückt
int sequence[100];      // Zu ratende Melodie; jeder Eintrag 0 - 3 als Index in notes[] bzw. buttons[]
int sequenceLength = 0; // Länge der Melodie bis jetzt
int currentNote = -1;   // Aktuell zu ratende / zu spielende Note als Index in sequence[]

void setup() {
  for(int i=0; i<4; i++) {
    pinMode(buttons[i], INPUT);
    pinMode(leds[i], OUTPUT);
  } 
  pinMode(speaker, OUTPUT);
  randomSeed(analogRead(0)); // Zufallszahlengenerator initialisieren
}

void loop() {
  if(guessing) { // Der Spieler ist dran
    // Prüfen, ob eine Taste gedrückt ist
    int currentButton = -1;
    for(int i=0; i<4; i++) {
      if(digitalRead(buttons[i]) == HIGH) {
        currentButton = i;
        break;
      }
    }
    if(currentButton != lastButton) { // Hat sich was geändert?
      if(lastButton != -1) { // Beim letzten Mal war eine Taste gedrückt, jetzt ist sie losgelassen
        digitalWrite(leds[lastButton], LOW);
        noTone(speaker);
        delay(10); // Prellen beim Loslassen verhindern
        lastButton = -1;
        if(currentNote < sequenceLength - 1) { // Die nächste Note ist dran
          currentNote++;
        }
        else { // Alles richtig eingegeben => Nächste Melodie vorspielen
          currentNote = -1;
          delay(500);
          guessing = false;
        }
      }
      if(currentButton != -1) { // Eine neue Taste wurde gedrückt
        if(currentButton == sequence[currentNote]) { // Passt die Taste zum nächsten Ton der Melodie?
          digitalWrite(leds[currentButton], HIGH);
          tone(speaker, notes[currentButton], 1000);
          lastButton = currentButton;
          delay(10); // Taste entprellen
        }
        else { // Falscher Ton wurde gedrückt
          tone(speaker, 98); // Note G2
          delay(500);
          noTone(speaker);
          tone(speaker, 65); // Note C2
          delay(500);
          noTone(speaker);
          delay(200);
          currentNote = -1;
          sequenceLength = 0; // Neue Melodie anfangen
          guessing = false;
        }
      }
    }
  }
  else { // Melodie vorspielen
    if(currentNote == -1) { // Melodie-Start? Dann hinten eine zufällige Note anhängen
      sequence[sequenceLength] = random(0, 4);
      sequenceLength++;
      currentNote = 0;
    }
    if(currentNote < sequenceLength) { // Sind noch Töne zu spielen?
      digitalWrite(leds[sequence[currentNote]], HIGH);
      tone(speaker, notes[sequence[currentNote]]);
      delay(500);
      digitalWrite(leds[sequence[currentNote]], LOW);
      noTone(speaker);
      currentNote++;
      delay(100);
    }
    else { // Alle Töne gespielt => Spieler muss raten
      currentNote = 0;
      guessing = true;
    }
  }
}
