; BASIC-Header
	*= $0801; Ladeadresse = BASIC
	!by $0b,$08,10,0,$9e,'2'
	!by '0','6','1',$00,$00,$00

main: ; hier geht's los
	jsr init_screen
	jsr init_sprite
	jsr init_irq
	jmp *; endlos

init_sprite:
	lda #100
	sta $d000; X-Position
	sta $d001; Y-Position
	lda #$0e ; hellblau
	sta $d027; Sprite-Farbe
	lda #$0b ; dunkelgrau
	sta $d025; Multicolor 0
	lda #$01 ; weiß
	sta $d026; Multicolor 1
	lda #1
	sta $d01c; Multicolor an
	sta $d015; sprite 0 an

	ldx #62
l1:	lda sprite,x
	sta $0340,x
	dex
	bpl l1

	lda #$0340/64
	sta $07f8; Block-Nr.

	lda $d01f; Kollision
	rts

sprite: ; Sprite-Daten
	!by $00,$1b,$d9,$00
	!by $56,$94,$01,$b9
	!by $00,$52,$fe,$40
	!by $a6,$eb,$80,$f6
	!by $96,$d0,$a6,$40
	!by $a4,$05,$04,$28
	!by $04,$0c,$19,$14
	!by $48,$4e,$24,$91
	!by $8f,$14,$66,$4e
	!by $04,$6e,$59,$05
	!by $19,$28,$a6,$40
	!by $a4,$f6,$96,$d0
	!by $a6,$eb,$80,$52
	!by $fe,$40,$01,$b9
	!by $00,$00,$56,$94
	!by $00,$1b,$d9

init_screen:
	jsr $e544; löschen
len = msg_end-msg
line = $0400+21*40
	ldx #len-1
i1:	lda msg,x
	sta line+(40-len)/2,x
	dex
	bpl i1
	rts
msg:	!scr "c't c64 game"
msg_end:
; Kollitions-Check
collision:
	lda $d01f; stattgefunden?
	beq c5
	inc $d027; color 0
c5:	rts

; Joystick abfragen und
; Sprite-Position updaten
control:
	ldx $dc00; Joystick Status
	txa
	and #1   ; UP
	bne c1
	lda $d001; Y-Koordinate
	cmp #50
	beq c1
	dec $d001
c1:	txa
	and #2   ; DOWN
	bne c2
	lda $d001
	cmp #50+18*8-21
	beq c2
	inc $d001
c2:	txa
	and #4   ; LEFT
	bne c3
	lda $d000; X-Koordinate
	cmp #24+7
	beq c3
	dec $d000
c3:	txa
	and #8   ; RIGHT
	bne c4
	lda $d000
	cmp #255
	beq c4
	inc $d000
c4:	rts
update_screen:
	lda scroll_offset
	beq u1
	dec scroll_offset
	rts
u1:	lda #7
	sta scroll_offset

; Bild um 1 Character nach
; links kopieren
	ldx #0
u2:	lda $0401,x
	sta $0400,x
	lda $0401+6*40,x
	sta $0400+6*40,x
	lda $0401+12*40,x
	sta $0400+12*40,x
	inx
	cpx #6*40
	bne u2

; neue Spalte erzeugen
	lda #<$0400
	sta $fe
	lda #>$0400
	sta $ff
	ldx #18
u3:	jsr new_char
	ldy #39
	sta ($fe),y
	lda $fe
	clc
	adc #40
	sta $fe
	bcc u4
	inc $ff
u4:	dex
	bne u3
	rts
new_char:
	lda $e000
	inc new_char+1
	cmp #2
	lda #' '
	bcs r1
	lda #'*'
r1:	rts
init_irq:
	sei
	lda #$7f
	sta $dc0d; Timer-IRQ
	lda $dc0d; abschalten
	lda #1   ; Video-IRQ
	sta $d01a; anschalten
	jsr setup_irq1
	cli
	rts

rasterline1 = 0
rasterline2 = 50+18*8

setup_irq1:
	ldx #<irq1
	ldy #>irq1
	lda #rasterline1
setup_irq:
  stx $0314; IRQ-Vektor Lo
	sty $0315; IRQ-Vektor Hi
	sta $d012; Trigger-Zeile
	lda $d011; 9. Bit der
	and #$7f ; Trigger-Zeile
	sta $d011; auf 0 setzen
	rts

setup_irq2:
	ldx #<irq2
	ldy #>irq2
	lda #rasterline2
	jmp setup_irq

scroll_offset:
	!by 0

irq1:
	inc $d019; IRQ bestätigen
		
	lda scroll_offset
	sta $d016; Soft-Scrolling

	jsr setup_irq2
	jmp $ea81; IRQ-Rücksprung

irq2:
	inc $d019; IRQ bestätigen

	lda #$08 ; Soft-Scrolling
	sta $d016; ausschalten

	jsr setup_irq1
	jsr control
	jsr collision
	jsr update_screen
	jmp $ea81; IRQ-Rücksprung
