/* Kleines Programm zum Entschluesseln von Bianca und Doris.
   Frank Rustemeyer <mambres@mud.tap.de>, 5.12.1999
   Aufruf: decode hauptmodul verschluesselungsexponent
   Die Zahlen des Chiffrats werden jeweils in einer
   eigenen Zeile von stdin gelesen 
*/

#include <stdio.h>

int nebenmodul(int k1)
{   int i = 3;
    
    while(i <= k1)
    {   if (!(k1 % i)) break;
        i += 2;
        }

    printf("Hauptmodul: %d = %d * %d\n", k1, i, (k1 / i));
    return (i-1) * ((k1 / i)-1);
    } 

int exponent(int nmod, int k2)
{   int faktor = 1;
    
    while (((faktor * k2) % nmod) != 1)
        faktor++;

    return faktor;
    }

int potenz(int basis, int expo)
{   int ergebnis=1;

    while(expo)
    {   ergebnis *= basis;
        expo--;
        }

    return ergebnis;
    }

int main(int argc, char **argv)
{   int key1, key2;
    int nmod, expo, n;
    char line[100];

    if (argc != 3)
    {   fprintf(stderr, "Usage: %s hauptmodul exponent\n", argv[0]);
        return 1;
        }
    if (sscanf(argv[1], "%d", &key1) != 1)
    {   fprintf(stderr, "%s: %s ist keine Integer-Zahl!\n", argv[0], argv[1]);
        return 1;
        }
    if (sscanf(argv[2], "%d", &key2) != 1)
    {   fprintf(stderr, "%s: %s ist keine Integer-Zahl!\n", argv[0], argv[2]);
        return 1;
        }

    nmod = nebenmodul(key1);
    expo = exponent(nmod, key2);

    printf("Nebenmodul: %d, Exponent: %d\n\n", nmod, expo);

    while(fgets(line, 100, stdin))
    {   if (sscanf(line, "%d", &n) != 1)
        {   fprintf(stderr, "%s: Warnung: %s ist keine Integer-Zahl!\n", argv[0], line);
            break;
            }
        printf("%c ", 'A' -1 + potenz((n % key1), expo) % key1);
        }
   
    printf("\n");
    return 0;
    } 

