<html>
<head>
  <title>Pic&apos;tur &ndash; Playlist Editor</title>
<?php
function filelist($path) {
  $files = array();
  $handle = opendir($path);
  while(($file = readdir($handle)) !== false) {
    if($file[0] != ".") {
      $type = mime_content_type($path.$file);
      if(strpos($type,"image/") === 0 || strpos($type,"video/") === 0) {
        array_push($files, $file);
      }
    }
  }
  sort($files);
  return $files;
}

function readpls($path) {
  $pls = array();
  $fh = fopen($path,"r");
  while(!feof($fh)) {
    $l = rtrim(fgets($fh),"\r\n");
    if(preg_match('/^([0-9]*[0-9hms]);(.+)/',$l,$m)==1) {
      array_push($pls,array("time" => $m[1], "name" => $m[2]));
    }
  }
  fclose($fh);
  // print "readpls\n";
  // var_dump($pls);
  return $pls;
}

function writepls($path,$pls) {
  $fh = fopen($path,"w");
  foreach($pls as $p)
    fwrite($fh, $p["time"].";".$p["name"]."\n");
  fclose($fh);
}

?>
</head>
<body>
  <h2 align="center">Pic&apos;tur &ndash; Playlist Editor</h2>
  <center>
    <p align="center"><a href="upload.php"><button>Upload</button></a> <a href="index.php"><button>Gallery</button></a></p>
  </center>
  <hr width="80%">
<?php
$path = "upload/";
$plsfile = "playlist.txt";

if(!empty($_POST["createpls"])) {
  if(!file_exists($path.$plsfile)) {
    touch($path.$plsfile);
  }
}
elseif(!empty($_POST["removepls"])) {
  if(is_writable($path.$plsfile)) {
    unlink($path.$plsfile);
  }
}
elseif(!empty($_POST["add"]) && !empty($_POST["pos"]) && isset($_POST["time"]) && (!empty($_POST["fname"]) || !empty($_POST["uname"]))) {
  if(!empty($_POST["fname"]) && substr($_POST["fname"],0,5) == "file:")
    $f = "file:".base64_decode(substr($_POST["fname"],5));
  if(!empty($_POST["uname"]))
    $f = $_POST["uname"];

  if(preg_match("/^[0-9]*[0-9hms]$/",$_POST["time"])==1 && preg_match("/^[0-9]+$/",$_POST["pos"])==1) {
    $pls = readpls($path.$plsfile);
    $p = intval($_POST["pos"]);
    if($p <= count($pls))
      array_splice($pls,$p-1,0,array(array("time" => $_POST["time"], "name" => $f)));
    else
      array_push($pls,array("time" => $_POST["time"], "name" => $f));
    writepls($path.$plsfile,$pls);
  }
}
elseif(!empty($_POST["change"]) && !empty($_POST["pos"]) && !empty($_POST["npos"]) && isset($_POST["time"])) {
  if(preg_match("/^[0-9]*[0-9hms]$/",$_POST["time"])==1 && preg_match("/^[0-9]+$/",$_POST["pos"])==1 && preg_match("/^[0-9]+$/",$_POST["npos"])==1) {
    $pls = readpls($path.$plsfile);
    $p = intval($_POST["pos"]);
    $n = intval($_POST["npos"]);
    if($p != $n) {
      $t = $pls[$p-1];
      array_splice($pls,$p-1,1);
      array_splice($pls,$n-1,0,array($t));
    }
    $pls[$n-1]["time"] = $_POST["time"];
    if(!empty($_POST["uname"]))
      $pls[$n-1]["name"] = $_POST["uname"];
    writepls($path.$plsfile,$pls);
  }
}
elseif(!empty($_POST["remove"]) && !empty($_POST["pos"])) {
  if(preg_match("/^[0-9]+$/",$_POST["pos"])==1) {
    $pls = readpls($path.$plsfile);
    $p = intval($_POST["pos"]);
    if($p <= count($pls))
      array_splice($pls,$p-1,1);
    writepls($path.$plsfile,$pls);
  }
}
?>

<?php

if(!file_exists($path.$plsfile)) {
?>
    <center>
      <form method="POST">
        <button name="createpls" value="1">Playlist anlegen</button>
      </form>
    </center>
<?php
} elseif(is_writable($path.$plsfile)) {

?>
    <table border="0" align="center">
      <tr>
        <th>Pos.</th>
        <th>Dauer</th>
        <th colspan="2">Datei</th>
        <th>Aktion</th>
      </tr>
<?php
  $pls = readpls($path.$plsfile);
  $files = filelist($path);

  for($p=0;$p<count($pls);$p++) {
?>
      <tr>
        <form method="POST">
        <input type="hidden" name="pos" value="<?= $p+1 ?>">
          <td>
            <select name="npos">
<?php
  for($i=0;$i<count($pls);$i++) { 
    printf('<option value="%d" %s>%d</option>',$i+1,$i==$p?"selected":"",$i+1);
  }
?>
            </select>
          </td>
          <td><input name ="time" type="text" size="3" value="<?= $pls[$p]["time"]; ?>"></td>
          <td align="center">
<?php
    if(substr($pls[$p]["name"],0,5)=="file:") {
      if(strpos(mime_content_type($path.substr($pls[$p]["name"],5)),"image/") === 0) {
?>
            <a href="<?= $path.substr($pls[$p]["name"],5) ?>" target="_new"><img height="50" src="<?= $path.substr($pls[$p]["name"],5) ?>"></a>
<?php
      }
      if(strpos(mime_content_type($path.substr($pls[$p]["name"],5)),"video/") === 0) {
?>
            <a href="<?= $path.substr($pls[$p]["name"],5) ?>" target="_new"><video height="50"><source src="<?= $path.substr($pls[$p]["name"],5) ?>"></video></a>
<?php
      }
    }
?>
          </td>
<?php
    if(substr($pls[$p]["name"],0,5)=="file:") {
?>
          <td><?= substr($pls[$p]["name"],5); ?></td>
<?php
    } else {
?>
          <td><input type="text" size="30" name="uname" value="<?= $pls[$p]["name"] ?>"></td>
<?php
    }
?>
          <td><button name="change" value="1" title="Übernehmen">U</button></td>
          <td><button name="remove" value="1" title="Löschen">X</button></td>
        </form>
      </tr>
<?php
  }
?>
      <tr>
        <form method="POST">
          <td>
            <select name="pos">
<?php
  for($i=0;$i<=count($pls);$i++) { 
    printf('<option value="%d" %s>%d</option>',$i+1,$i==count($pls)?"selected":"",$i+1);
  }
?>
            </select>
          </td>
          <td><input name ="time" type="text" size="3" value="5"></td>
          <td>&nbsp;</td>
          <td>
            URL: <input type="text" size="30" name="uname" value="<?= $pls[$p]["name"] ?>">
            <br>
            Datei: <select name="fname">
              <option></option>
<?php
  foreach($files as $f) { 
    printf('<option value="file:%s">%s</option>',base64_encode($f),$f); 
  }
?>
            </select>
          </td>
          <td><button name="add" value="1" title="Hinzufügen">+</button></td>
        </form>
      </tr>
    </table>
<?php
}
?>
  <hr width="80%">
<?php
  if(is_writable($path.$plsfile)) {
?>
  <center>
    <form method="POST">
      <button name="removepls" value="1">Playlist löschen</button>
    </form>
  </center>
<?php
  }
?>
</body>
</html>
