{*** Bhrmann / c't  3/1990 ***}

{*** bentigt Formunit aus c't 2/1990 und Compare.obj ***}

PROGRAM dcc; {$I-,E-,V-,O-,R-}
USES Crt, Formunit;

CONST
 NAME : STRING[25] = 'Bhrmann - c''t 1990';          {Dateierkennung}

TYPE
 sektor = ARRAY[0..511] OF Byte;                          {Ein Sektor}
 puffer = ARRAY[0..126] OF sektor;                 {64 KB Datenpuffer}
 dest = ARRAY[0..19] OF sektor;       {Vergleich fr max. 20 Sektoren}
 pufferzeig = ^puffer;                        {Zeiger auf Datenpuffer}
 destzeig = ^dest;                          {Zeiger auf Comparepuffer}

VAR
 source, target : ShortInt;                      {Quell- und Zieldisk}
 format, verify : Boolean;                      {Format oder Verify ?}
 compare : Boolean;                          {Disketten vergleichen ?}
 manuell, estep : Boolean; {Manuelle Parametereingabe ?, Einzelstep ?}
 prompt, low : Boolean;  {Einlegen der Disk besttigen ?, Low Density}
 sdisk, tdisk, vfehler : Boolean;  {Fehler bei Read/Write oder Verify}
 trk, side, sek : Byte;                           {Manuelle Parameter}
 batch, fparam : Boolean;    {Flag fr Batchbetrieb, Fehler bei Batch}
 taste, einzel, srate : Char;         {Taste, Einzelstep, Schreibrate}
 schreibpuffer : pufferzeig;                       {64 KB Datenpuffer}
 diskpuffer, destpuffer : destzeig;  {10 KB Disketten-, Comparepuffer}
 heap : Pointer;                           {Zeiger auf aktuellen Heap}
 diskprompt, diskcomp : STRING[1];     {Prompt, Diskcopy oder Compare}
 aktion, laufwstr : STRING[1];   {Read oder Write bei Batch, Laufwerk}
 datdmy, dateiname : STRING[50];                 {Massenspeicherdatei}
 {**********************Unterprogramme************************}
 PROCEDURE ausgang(VAR datei : FILE);
 BEGIN
  Close(datei); Release(heap);    {alle dynamischen Variablen lschen}
  laufwerkstabalt;         {Datei schlieen und alte Laufwerkstabelle}
 END;
 {************************************************************}
 FUNCTION dnotready : Char;               {Keine Diskette im Laufwerk}
 BEGIN
  IF NOT batch THEN window(1, 13, 80, 25);
  WriteLn;
  WriteLn('Es befindet sich keine Diskette im Laufwerk, ');
  WriteLn('oder die Laufwerksklappe ist nicht geschlossen.');
  WriteLn('Bitte Diskette einlegen, oder Klappe schlieen.');
  WriteLn('Abbruch mit ESC');
  dnotready := readkey;                                  {Taste lesen}
  IF NOT batch THEN
   BEGIN
    clrscr; window(1, 1, 80, 25);                    {Fenster lschen}
   END;
 END;
 {************************************************************}
 PROCEDURE diskettenformat(anzspur, anzseite, anzsektor : Byte);
 VAR x, y : Byte;
 BEGIN
  x := wherex; y := wherey;                      {Alten Cursor merken}
  IF NOT batch THEN window(60, 2, 80, 25);
  WriteLn; WriteLn('Diskettenformat');
  WriteLn(anzspur:4, ' : Spuren');
  WriteLn(anzseite:4, ' : Seite(n)');
  WriteLn(anzsektor:4, ' : Sektoren');
  WriteLn(Round(anzspur*anzsektor*anzseite*0.5):4, ' : KByte');
  IF NOT batch THEN
   BEGIN
    window(1, 1, 80, 25);
    gotoxy(x, y);                            {Cursor an alte Position}
   END;
 END;
 {************************************************************}
 {$F+}
 FUNCTION vergleich(VAR spuffer, dpuffer;
 anzsektor : Byte) : Boolean; EXTERNAL;        {$L compare.obj}
 {$F-}
 {************************************************************}
 PROCEDURE formchange;
 BEGIN
  IF NOT batch THEN
   BEGIN
    highvideo; gotoxy(1, 4);
    WriteLn('(F)ormat : ON '); WriteLn('(V)erify : ON ');
    lowvideo;
   END;
  format := True; verify := True;
 END;
 {************************************************************}
 PROCEDURE parameter;
 BEGIN
  window(1, 15, 80, 25); gotoxy(14, 1);
  Write('Manuelle Parametereingabe, ');
  WriteLn('ohne berprfung der Werte');
  gotoxy(1, 3); Write('Anzahl der Spuren : '); ReadLn(trk);
  Write('Anzahl der Seiten : '); ReadLn(side);
  Write('Anzahl der Sektoren pro Seite : '); ReadLn(sek);
  IF (laufwerka = 2) OR (laufwerkb = 2) OR
  (laufwerka = 4) OR (laufwerkb = 4) THEN
   BEGIN
    Write('Schreibdichte (H/L) : '); ReadLn(srate);
    srate := Upcase(srate);                   {Gewnschte Schreibrate}
    IF srate = 'H' THEN low := False ELSE low := True;
    IF (laufwerka = 2) OR (laufwerkb = 2) THEN
     BEGIN                                              {Schrittweite}
      Write('Einzelstep (J/N) : '); ReadLn(einzel);
      einzel := Upcase(einzel);
      IF einzel = 'J' THEN estep := True ELSE estep := False;
     END;
   END;
  clrscr;
  window(1, 1, 80, 25); gotoxy(13, 9);
 END;
 {************************************************************}
 FUNCTION bootsektor(VAR anzspur, anzseite,
                     anzsektor : LongInt; laufwerk : Byte;
                     VAR media : Byte) : Byte;
 TYPE
  boot = RECORD
          nothing1 : ARRAY[0..18] OF Byte;
          sektoren : Word;                  {Anzahl Sektoren auf Disk}
          nothing2 : ARRAY[0..2] OF Byte;
          sekprotr : Word;                         {Sektoren pro Spur}
          anzkopf : Word;                          {Anzahl der Seiten}
          nothing3 : ARRAY[0..995] OF Byte;
         END;
 VAR
  bootpuffer : boot;
 BEGIN
  bootpuffer.sekprotr := $ff; bootpuffer.anzkopf := $ff;
  {Physikalische Parameter lschen,  Bootsektor + 1. FAT Sektor lesen}
  bootsektor := readwriteverify(2, 0, 0, 1, 2,
                                laufwerk, bootpuffer);
  anzsektor := bootpuffer.sekprotr;
  anzseite := bootpuffer.anzkopf;
  IF (anzseite <> 0) AND (anzsektor <> 0) THEN
   anzspur := Round(bootpuffer.sektoren/anzseite/anzsektor)
  ELSE anzspur := 0;                               {Ungltiges Format}
  media := bootpuffer.nothing3[484];                 {Mediabyte lesen}
  IF (anzspur = 0) AND (media >= $F0) THEN anzspur := 1;
  {Es kann doch ein gltiges Format sein}
 END;
 {************************************************************}
 PROCEDURE diskcopy;
 VAR
  anzspur, anzseite, anzsektor : LongInt;             {Quellparameter}
  dspur, dseite, dsektor : LongInt;                    {Zielparameter}
  spur, seite : Byte;                                 {Aktuelle Werte}
  media : Byte;                               {Mediabyte der Diskette}
  gesamt, dummy : Word;                        {Gesamte Diskkapazitt}
  maxsektor, sekread, i : Word;
  kap, abssektor, anzahl : Byte;         {Art der Schreibrate, Sektor}
  artsource, arttarget : Byte;                     {Art der Laufwerke}
  tabelle : Boolean;                                       {Neue DDPT}
  fileerror : Boolean;                                {Dateierkennung}
  booterr : Boolean;                                {Bootsektorfehler}
  fehler : Byte;                  {Fehler bei Diskzugriff aufgetreten}
  taste : Char;
  datei : FILE;
 BEGIN
  Mark(heap);                                  {aktuellen Heap merken}
  IF NOT batch THEN
   BEGIN
    highvideo;
    IF compare THEN
     BEGIN
      gotoxy(23, 8); Write('Diskettencompare von ');
     END
    ELSE
     BEGIN
      gotoxy(15, 9); Write('Diskettendiskcopy von ');
     END;
    IF source = 0 THEN Write('A') ELSE Write('B');
    Write(' nach ');
    IF target = 0 THEN WriteLn('A') ELSE WriteLn('B');
    lowvideo;
   END;
  sdisk := False;               {Fehler aufgetreten, Disk unbrauchbar}
  booterr := False;                         {Unbrauchbarer Bootsektor}
  IF source = 0 THEN artsource := laufwerka
  ELSE artsource := laufwerkb;
  IF target = 0 THEN arttarget := laufwerka
  ELSE arttarget := laufwerkb;
  tabelle := False;                             {Noch keine neue DDPT}
  taste := '';
  New(schreibpuffer);                              {64 KB Datenpuffer}
  New(diskpuffer);                             {10 KB Diskettenpuffer}
  Assign(datei, dateiname);
  IF aktion = 'R' THEN Erase(datei);         {Neues Imagefile anlegen}
  Reset(datei, 512);                      {Datei zum Schreiben ffnen}
  IF (IoResult = 0) AND NOT batch THEN
   BEGIN                {Datei ist schon auf Massenspeicher vorhanden}
    IF NOT batch THEN gotoxy(1, 11);
    IF NOT compare THEN
     BEGIN
      Write('Datei vorhanden : ()berschreiben oder ');
      Write('auf (Z)ieldiskette');
     END
    ELSE
     BEGIN
      Write('Comparedatei vorhanden : ()berschreiben oder ');
      Write('mit (Z)ieldiskette vergleichen');
     END;
    REPEAT
     taste := Upcase(readkey);
    UNTIL (taste = #129) OR (taste = #154) OR
    (taste = 'Z') OR (taste = #27);
    delline; Close(datei);
   END;
  IF taste = #27 THEN
   BEGIN
    Release(heap);
    IF NOT batch THEN Exit ELSE Halt(1);
   END;
  IF batch AND (aktion = 'W') THEN taste := 'Z'; {Direkt auf Zieldisk}
  IF ((taste = #129) OR (taste = #154)) THEN
   BEGIN
    IF NOT batch THEN gotoxy(1, 11);
    IF prompt THEN
     BEGIN
      Write('Bitte Quelldiskette in ');
      highvideo;
      IF source = 0 THEN Write('A') ELSE Write('B');
      lowvideo;
      WriteLn(' einlegen, weiter mit beliebiger Taste');
      taste := readkey;
      IF taste = #27 THEN
       BEGIN
        Release(heap);
        IF NOT batch THEN Exit ELSE Halt(1);
       END;
      delline;
     END;
    REPEAT
     IF NOT manuell THEN                   {Keine manuellen Parameter}
      fehler := bootsektor(anzspur, anzseite, anzsektor,
                           source, media)
     ELSE
      BEGIN                          {Manuelle Parameter fr Diskcopy}
       anzspur := trk;
       anzseite := side;
       anzsektor := sek;
      END;
     IF fehler = $80 THEN taste := dnotready;   {Keine Disk eingelegt}
     IF taste = #27 THEN
      BEGIN
       Release(heap);
       IF NOT batch THEN Exit ELSE Halt(1);
      END;
    UNTIL fehler <> $80;                    {Abbruch, wenn Disk ready}
    gesamt := Round(anzspur*anzsektor*anzseite*0.5);
    IF NOT manuell THEN                    {keine manuellen Parameter}
     BEGIN
      IF (gesamt <> 360) AND (gesamt <> 720) AND
      (gesamt <> 1200) AND (gesamt <> 1440) THEN
       {keine Standardformate}
       IF (media < $F0) THEN anzspur := 0
       ELSE booterr := True;
      {Unbekanntes Diskettenformat}
      IF ((fehler <> 0) OR (anzspur = 0)) THEN
       BEGIN
        IF NOT batch THEN gotoxy(1, 11);
        Write('Bootsektor ist nicht lesbar, ');
        WriteLn('oder ungltiges Diskettenformat  !');
        Write('Diskettenparameter bitte Manuell eingeben ');
        taste := readkey;
        Release(heap);
        IF NOT batch THEN Exit ELSE Halt(1);
       END;
      IF booterr THEN
      {Mediabyte auswerten, wenn kein brauchbarer Bootsektor}
       CASE media OF
        $F0 : BEGIN anzspur := 80; anzseite := 2; anzsektor := 18; END;
        {1440 KB}
        $F9 : BEGIN anzspur := 80; anzseite := 2; anzsektor := 15; END;
        {1220 KB}
        $FC : BEGIN anzspur := 40; anzseite := 1; anzsektor := 9; END;
        {180 KB}
        $FD : BEGIN anzspur := 40; anzseite := 2; anzsektor := 9; END;
        {360 KB}
        $FE : BEGIN anzspur := 40; anzseite := 1; anzsektor := 8; END;
        {160 KB}
        $FF : BEGIN anzspur := 40; anzseite := 2; anzsektor := 8; END;
        {320 KB}
       END;
     END;
    diskettenformat(anzspur, anzseite, anzsektor);
    {Format der Diskette ausgeben}
    IF anzsektor < 11 THEN kap := 1 ELSE kap := 3;
    {Niedrige oder hohe Schreibdichte als Default}
    IF manuell THEN                     {Parameter manuell eingegeben}
     BEGIN
      IF artsource = 1 THEN kap := 1;          {360 KB, 5.25 Laufwerk}
      IF artsource = 3 THEN kap := 2;           {720 KB, 3.5 Laufwerk}
      IF artsource = 2 THEN                   {1200 KB, 5.25 Laufwerk}
       BEGIN
        IF estep AND low THEN kap := 2
        ELSE IF estep AND NOT low THEN kap := 3
        ELSE kap := 1;
       END;
      IF artsource = 4 THEN
       IF NOT low THEN kap := 4 ELSE kap := 1
     END;
    CASE gesamt OF
     360 : kap := 1;              {Schreibdichte bei Standardformaten}
     720 : kap := 2;
     1200 : kap := 3;
     1440 : kap := 4;
    END;
    schreibrate(artsource, kap, source);
    laufwerkstabneu;
    maxsektor := anzspur*anzseite*anzsektor;       {abs. Sektorenzahl}
    Rewrite(datei, 512);
    FOR i := 0 TO 511 DO schreibpuffer^[0, i] := 0;
    {Anfangsblock der Datei lschen}
    schreibpuffer^[0, 0] := anzspur;
    schreibpuffer^[0, 1] := anzseite;
    schreibpuffer^[0, 2] := anzsektor;
    FOR i := 493 TO 511 DO schreibpuffer^[0, i] := Ord(NAME[i-492]);
    {Dateikennung in Puffer schreiben}
    BlockWrite(datei, schreibpuffer^[0, 0], 1);
    {Physikalische Parameter der Diskette in Datei schreiben}
    Dec(anzspur); Dec(anzseite);       {Spur und Seite beginnen bei 0}
    sekread := 0; abssektor := 0;
    FOR spur := 0 TO anzspur DO
     BEGIN
      FOR seite := 0 TO anzseite DO
       BEGIN
        IF (abssektor+anzsektor) > 126 THEN
         BEGIN
          BlockWrite(datei, schreibpuffer^[0, 0],
                     abssektor, dummy);
          IF abssektor <> dummy THEN
           BEGIN
            IF NOT batch THEN gotoxy(8, 6);
            Write('Zwischenspeicher ist voll !');
            taste := readkey;
            ausgang(datei);
            Erase(datei);                {Datei schlieen und lschen}
            IF NOT batch THEN Exit ELSE Halt(1);
           END;
          abssektor := 0;
         END;
        REPEAT
         fehler := readwriteverify(2, spur, seite, 1, anzsektor,
                                   source, diskpuffer^[0, 0]);
         {Diskettendaten in Diskpuffer schreiben}
         Move(diskpuffer^[0, 0],
              schreibpuffer^[abssektor, 0], anzsektor*512);
         {Daten in Schreibpuffer kopieren}
         IF fehler = $80 THEN taste := dnotready;
         {Keine Diskette eingelegt}
         IF taste = #27 THEN
          BEGIN
           ausgang(datei);
           Erase(datei);
           IF NOT batch THEN Exit ELSE Halt(1);
          END;
         IF fehler = 9 THEN New(diskpuffer);
         {DMA bertragung ber 64 KB Grenze}
        UNTIL (fehler <> $80) AND (fehler <> 9);
        {Abbruch, wenn Disk ready und kein DMA Fehler}
        IF fehler <> 0 THEN
         BEGIN
          IF NOT batch THEN gotoxy(1, 14);
          sdisk := True;                        {Fehler bei Quelldisk}
          WriteLn('  Fehler Seite : ', seite, '  Spur : ', spur);
         END;
        Inc(abssektor, anzsektor);
        Inc(sekread, anzsektor);
        IF NOT batch THEN gotoxy(1, 12) ELSE gotoxy(1, wherey);
        Write('Lese Seite : ', seite, '  Spur : ', spur);
        IF keypressed THEN               {wurde eine Taste bettigt ?}
         BEGIN
          taste := readkey;
          IF taste = #27 THEN                      {Abbruch durch ESC}
           BEGIN
            ausgang(datei);
            Erase(datei);
            IF NOT batch THEN Exit ELSE Halt(1);
           END;
         END;
       END;
     END;
    BlockWrite(datei, schreibpuffer^[0, 0], abssektor);
    Close(datei); delline; delline; delline;
    laufwerkstabalt;
   END;
  IF aktion <> 'R' THEN
   BEGIN
    REPEAT
     tdisk := False;
     vfehler := False;
     Reset(datei, 512);                   {Datei zum Schreiben ffnen}
     IF batch AND (IoResult <> 0) THEN
      BEGIN
       WriteLn('Massenspeicherdatei existiert nicht !');
       Halt(1);
      END;
     BlockRead(datei, schreibpuffer^[0, 0], 1);
     {Physikalische Parameter der Diskcopydatei lesen}
     anzspur := schreibpuffer^[0, 0];
     anzseite := schreibpuffer^[0, 1];
     anzsektor := schreibpuffer^[0, 2];
     i := 493;                                {Start der Dateikennung}
     REPEAT
      IF Ord(NAME[i-492]) <> schreibpuffer^[0, i] THEN
       fileerror := True                           {Keine Backupdatei}
      ELSE fileerror := False;
      Inc(i, 1);
     UNTIL fileerror OR (i > 511);
     IF fileerror THEN
      BEGIN
       IF NOT batch THEN gotoxy(1, 11);
       Write('Datei ist kein Diskcopyfile. ');
       Write('Weiter mit beliebiger Taste');
       taste := readkey;
       Close(datei);
       Release(heap);
       IF NOT batch THEN Exit ELSE Halt(1);
      END;
     gesamt := Round(anzspur*anzsektor*anzseite*0.5);
     {Diskettenkapazitt}
     IF anzsektor < 11 THEN kap := 1 ELSE kap := 3;
     {Niedrige oder hohe Schreibdichte als Default}
     IF manuell THEN                    {Parameter manuell eingegeben}
      BEGIN                                                {arttarget}
       IF arttarget = 1 THEN kap := 1;         {360 KB, 5.25 Laufwerk}
       IF arttarget = 3 THEN kap := 2;          {720 KB, 3.5 Laufwerk}
       IF arttarget = 2 THEN                  {1200 KB, 5.25 Laufwerk}
        BEGIN
         IF estep AND low THEN kap := 2
         ELSE IF estep AND NOT low THEN kap := 3
         ELSE kap := 1;
        END;
       IF arttarget = 4 THEN
        IF NOT low THEN kap := 4 ELSE kap := 1
      END;
     CASE gesamt OF
      360 : kap := 1;             {Schreibdichte bei Standardformaten}
      720 : kap := 2;
      1200 : kap := 3;
      1440 : kap := 4;
     END;
     diskettenformat(anzspur, anzseite, anzsektor);
     maxsektor := anzspur*anzseite*anzsektor;      {abs. Sektorenzahl}
     IF NOT batch THEN gotoxy(1, 11);
     IF prompt THEN
      BEGIN
       Write('Bitte Zieldiskette in ');
       highvideo;
       IF target = 0 THEN Write('A') ELSE Write('B');
       lowvideo;
       WriteLn(' einlegen, weiter mit beliebiger Taste ');
       taste := readkey;
       IF taste = #27 THEN
        BEGIN
         Close(datei);
         Release(heap);
         IF tabelle THEN laufwerkstabalt;
         IF NOT batch THEN Exit ELSE Halt(1);
        END;
       delline;
      END;
     Dec(anzspur);
     Dec(anzseite);                    {Seite und Spur beginnen bei 0}
     IF (NOT format) OR (format AND compare) THEN
      BEGIN
       REPEAT
        fehler := bootsektor(dspur, dseite, dsektor,
                             target, media);
        IF fehler = $80 THEN taste := dnotready;
        {Keine Diskette eingelegt}
        IF taste = #27 THEN
         BEGIN
          Close(datei);
          Release(heap);
          IF tabelle THEN laufwerkstabalt;
          IF NOT batch THEN Exit ELSE Halt(1);
         END;
       UNTIL fehler <> $80;                 {Abbruch, wenn Disk ready}
       IF ((dspur <> anzspur+1) OR (dseite <> anzseite+1) OR
           (dsektor <> anzsektor) OR (fehler <> 0)) AND NOT batch THEN
        BEGIN
         Write('Ungleiches Zielformat : ');
         WriteLn((dspur*dsektor*dseite*512) DIV 1024, ' KByte');
         IF compare THEN
          Write('Doch Vergleichen ? (J/N) ')
         ELSE Write('Doch Formatieren ? (J/N) ');
         taste := Upcase(readkey);
         delline;
         IF (taste = #27) OR (taste = 'N') THEN
          BEGIN
           Close(datei);
           Release(heap);
           IF tabelle THEN laufwerkstabalt;
           IF NOT batch THEN Exit ELSE Halt(1);
          END;
         IF NOT compare AND (taste = 'J') THEN formchange;
         {Diskcopy mit formatieren}
        END;
      END;
     schreibrate(arttarget, kap, target);
     IF NOT tabelle THEN
      BEGIN
       laufwerkstabneu;                         {Noch keine neue DDPT}
       tabelle := True;                       {Neue DDPT eingerichtet}
      END;
     IF compare THEN New(destpuffer);
     {Diskettendaten vergleichen}
     abssektor := 0; sekread := 0;
     FOR spur := 0 TO anzspur DO
      BEGIN
       FOR seite := 0 TO anzseite DO
        BEGIN
         IF abssektor = 0 THEN
          BEGIN
           anzahl := (127 DIV anzsektor)*anzsektor;
           BlockRead(datei, schreibpuffer^[0, 0], anzahl, dummy);
          END;
         IF NOT compare THEN
          BEGIN
           IF NOT batch THEN gotoxy(1, 12) ELSE gotoxy(1, wherey);
           Write('Schreibe Seite : ', seite, '  Spur : ', spur);
           Write('      ');             {Andere Meldung berschreiben}
           REPEAT
            taste := #0;                        {Tastaturcode lschen}
            IF (fehler <> 0) AND (fehler <> $80)
            AND NOT format THEN formchange;
            {Fehler beim Schreiben, nun doch formatieren}
            IF format THEN
             fehler := spurformat(spur, seite, 1,
                                  anzsektor, target);
            Move(schreibpuffer^[abssektor, 0],
                 diskpuffer^[0, 0], anzsektor*512);
            {Daten in Diskpuffer kopieren}
            fehler := readwriteverify(3, spur, seite, 1,
                                      anzsektor, target,
                                      diskpuffer^[0, 0]);
            {Diskpuffer auf Diskette schreiben}

            IF verify THEN
             fehler := readwriteverify(4, spur, seite, 1,
                                       anzsektor, target,
                                       diskpuffer^[0, 0]);
            IF fehler = $80 THEN taste := dnotready;
            IF fehler = 3 THEN             {Diskette schreibgeschtzt}
             BEGIN
              IF NOT batch THEN gotoxy(1, 14);
              WriteLn('Diskette ist schreibgeschtzt !');
              Write('Bitte Schreibschutz entfernen, ');
              WriteLn('weiter mit beliebiger Taste ');
              taste := readkey;
              IF taste = #27 THEN                  {Abbruch durch ESC}
               BEGIN
                ausgang(datei);
                IF compare THEN Release(heap);
                IF NOT batch THEN Exit ELSE Halt(1);
               END;
              IF NOT batch THEN                {Fehlermeldung lschen}
               BEGIN
                window(1, 14, 80, 25);
                clrscr;
                window(1, 1, 80, 25);
               END;
              fehler := $80;         {Schreiben noch einmal versuchen}
             END;
            IF fehler = 9 THEN New(diskpuffer);
            {DMA-bertragung ber Segmentgrenze}
           UNTIL ((fehler = 0) OR format) AND
           (fehler <> $80) AND (fehler <> 9);
          END
         ELSE
          BEGIN
           REPEAT
            vfehler := False;
            {Vergleichsfehler aufgetreten ?}

            IF NOT batch THEN gotoxy(1, 12)
            ELSE gotoxy(1, wherey);
            Write('Vergleiche Seite : ', seite, '  Spur : ', spur);
            Write('      ');            {Andere Meldung berschreiben}
            fehler := readwriteverify(2, spur, seite, 1,
                                      anzsektor, target,
                                      destpuffer^[0, 0]);
            IF fehler = $80 THEN taste := dnotready;
            IF fehler = 9 THEN New(destpuffer);
            {DMA-bertragung ber 64 KB Grenze hinaus}
           UNTIL (fehler <> $80) AND (fehler <> 9);
           {Abbruch, wenn Laufwerk bereit}
           vfehler := vergleich(schreibpuffer^[abssektor, 0],
                                destpuffer^[0, 0], anzsektor);
           {Daten der Massenspeicher vergleichen}
          END;
         IF (fehler <> 0) OR vfehler THEN
          BEGIN
           IF NOT batch THEN gotoxy(1, 14);
           tdisk := True;                        {Fehler bei Zieldisk}
           WriteLn('  Fehler Seite : ', seite, '  Spur : ', spur);
          END;
         Inc(abssektor, anzsektor); Inc(sekread, anzsektor);
         IF abssektor = anzahl THEN abssektor := 0;
         IF keypressed THEN              {wurde eine Taste bettigt ?}
          BEGIN
           taste := readkey;
           IF taste = #27 THEN                     {Abbruch durch ESC}
            BEGIN
             ausgang(datei);
             IF compare THEN Release(heap);
             IF NOT batch THEN Exit ELSE Halt(1);
            END;
          END;
        END;
      END;
     IF NOT batch THEN
      BEGIN
       gotoxy(1, 12);
       IF sdisk OR tdisk OR vfehler THEN
        WriteLn('Kopie der Diskette evt. unbrauchbar !')
       ELSE
        BEGIN
         IF NOT compare THEN Write('Diskcopy konnte ')
         ELSE Write('Vergleich konnte ');
         WriteLn('fehlerfrei durchgefhrt werden');
        END;
       delline;
       Write('Weitere Kopie oder weiterer Vergleich ');
       Write('(J/N)  ');
       taste := Upcase(readkey);
       window(1, 12, 80, 25);
       clrscr;
       window(1, 1, 80, 25);
      END;
    UNTIL (taste <> 'J') OR batch;
   END;
  ausgang(datei);
  IF compare THEN Release(heap); WriteLn;
 END;
 {**********************Hauptprogramm*************************}
BEGIN
 lowvideo;
 checkbreak := False;                  {Kein Abbruch durch CRTL-Break}
 IF ParamCount < 1 THEN batch := False ELSE batch := True;
 {Programmaufruf mit oder ohne Kommandozeile}
 source := 0; target := 0;             {Standarddiskcopy von A nach A}
 dateiname := 'dcc.bac';                {Name der Massenspeicherdatei}
 format := False; verify := False;          {Kein Format, kein Verify}
 compare := False;                       {Keine Disketten vergleichen}
 manuell := False;                                {Manuelle Parameter}
 prompt := True; aktion := '';           {Diskettenwechsel besttigen}
 fparam := False;                            {Fehler in Kommandozeile}
 IF batch THEN
  BEGIN
   aktion := ParamStr(1);          {Read oder Write eines Imagesfiles}
   aktion := Upcase(aktion[1]);
   laufwstr := ParamStr(2);                    {Ausgewhltes Laufwerk}
   IF aktion = 'R' THEN
    BEGIN
     source := Ord(Upcase(laufwstr[1]))-65;
     taste := 'D';                       {Bei Read Diskcopy ausfhren}
    END
   ELSE IF aktion = 'W' THEN target := Ord(Upcase(laufwstr[1]))-65
   ELSE fparam := True;                         {Fehler bei Parameter}
   IF (source > 1) OR (target > 1) THEN fparam := True;       {Fehler}
   IF ((source = 0) OR (target = 0)) AND (laufwerka = 0)
   THEN fparam := True;                        {Fehler, kein Laufwerk}
   IF ((source = 1) OR (target = 1)) AND (laufwerkb = 0)
   THEN fparam := True;                        {Fehler, kein Laufwerk}
   dateiname := ParamStr(3);
   IF dateiname = '' THEN
    BEGIN
     fparam := True;                          {Fehler, kein Dateiname}
     dateiname := 'dcc.bac';
     {Name der Massenspeicherdatei}
    END;
   diskprompt := ParamStr(4);
   diskprompt := Upcase(diskprompt[1]);
   IF diskprompt = 'N' THEN prompt := False ELSE prompt := True;
   diskcomp := ParamStr(5);
   diskcomp := Upcase(diskcomp[1]);
   IF NOT(aktion = 'R') THEN           {optionaler Parameter bei Read}
    BEGIN
     IF diskcomp = 'D' THEN compare := False                {Diskcopy}
     ELSE IF diskcomp = 'C' THEN compare := True
     ELSE fparam := True;                         {Falscher Parameter}
     IF compare THEN taste := 'C' ELSE taste := 'D';
    END;                              {Wahl von Diskcopy oder Compare}
   IF fparam THEN batch := False;              {Fehler bei Parametern}
  END;
 REPEAT
  IF NOT batch THEN
   BEGIN
    clrscr;
    IF fparam THEN
     BEGIN
      gotoxy(1, 16);
      Write('Fehler in den Kommandozeilenparametern, ');
      WriteLn('oder falsches Laufwerk');
      Write('Korrekter Aufruf lautet : ');
      WriteLn('DCC R/W Q/Z dat P/N [D/C]');
      WriteLn('R/W : Read bzw. Write eines Imagesfiles');
      WriteLn('Q/Z : Quell- bzw. Ziel-Laufwerk');
      WriteLn('dat : Name der Massenspeicherdatei');
      WriteLn('P/N : Prompting / No Prompting des Diskwechsels');
      WriteLn('D/C : Anzugeben bei Write. Diskcopy oder Compare');
     END;
    gotoxy(35, 1); Write('Hauptmen :');
    gotoxy(1, 2); Write('(Q)uell-Laufwerk : ');
    IF source = 0 THEN WriteLn('A') ELSE WriteLn('B');
    Write('(Z)iel-Laufwerk : ');
    IF target = 0 THEN WriteLn('A') ELSE WriteLn('B');
    Write('(F)ormat : ');
    IF format THEN WriteLn('ON') ELSE WriteLn('OFF');
    Write('(V)erify : ');
    IF verify THEN WriteLn('ON') ELSE WriteLn('OFF');
    Write('Datei-(N)ame [Pfad] : '); WriteLn(dateiname);
    IF manuell THEN
     BEGIN
      highvideo;                            {High wenn Manuellbetrieb}
      diskettenformat(trk, side, sek);        {Manuellformat ausgeben}
      WriteLn('(M)anuelle Parametereingabe : ON');
      lowvideo;
     END
    ELSE WriteLn('(M)anuelle Parametereingabe : OFF');
    WriteLn('(C)ompare Disketten');
    Write('(D)iskcopy  ');
    taste := Upcase(readkey);
    IF fparam AND NOT(taste = #27) THEN
     BEGIN
      window(1, 16, 80, 25); clrscr; window(1, 1, 80, 25);
      fparam := False;                            {Kein Batching mehr}
     END;
   END;
  CASE taste OF
   'Q' : IF (source = 0) AND (laufwerkb <> 0) THEN
         source := 1 ELSE source := 0;
   'Z' : IF (target = 0) AND (laufwerkb <> 0) THEN
         target := 1 ELSE target := 0;
   'F' : IF format THEN format := False ELSE format := True;
   'V' : IF verify THEN verify := False ELSE verify := True;
   'N' : BEGIN
          gotoxy(15, 12); Write('Name der Datei : ');
          ReadLn(datdmy);
          IF datdmy <> '' THEN dateiname := datdmy;
          {Abfangen eines Leerstrings}
         END;
   'M' : BEGIN
          IF manuell THEN manuell := False
          ELSE
           BEGIN
            manuell := True;               {Manuelle Parametereingabe}
            parameter;                                 {Parametermen}
            IF taste = #27 THEN
             BEGIN
              taste := #0;
              manuell := False;                      {Abbruch mit ESC}
             END;
           END;
         END;
   'C' : BEGIN
          compare := True;                     {Disketten vergleichen}
          diskcopy;                            {Start des Vergleiches}
          compare := False;
         END;
   'D' : diskcopy;                       {Start des Diskcopyprogramms}
  END;
 UNTIL (taste = #27) OR batch;
 IF batch AND (sdisk OR tdisk OR vfehler) THEN Halt(1);  {Batchfehler}
 IF NOT batch AND NOT fparam THEN clrscr;
 IF fparam THEN gotoxy(1, 23);
END.
