﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Navigation;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using Microsoft.FlightSimulator.SimConnect;

namespace SimConnectTest
{
    public partial class Flugdaten : Form
    {
        public Flugdaten()
        {
            InitializeComponent();
        }

        protected override void WndProc(ref Message m)
        {
            base.WndProc(ref m);
            if (m.Msg == WM_USER_SIMCONNECT)
            {
                m_oSimConnect?.ReceiveMessage();
            }
        }

        public const int WM_USER_SIMCONNECT = 0x0402;
        private SimConnect m_oSimConnect = null;
        private bool Registriert = false;
        
        public enum DEFINITION
        {
            Alt = 0,
            Speed = 1,
            Gears = 2
        };

        public enum REQUEST
        {
            Alt = 0,
            Speed = 1,
            Gears = 2
        };

        public DEFINITION eDef = DEFINITION.Alt;        
        public REQUEST eRequest = REQUEST.Alt;

        /*protected HwndSource GetHWinSource()
        {
            return PresentationSource.FromVisual(this) as HwndSource;
        }*/


        private void Connect_Click(object sender, EventArgs e)
        {
            if (m_oSimConnect == null)
                try
                {
                    /// Der constructor ist ähnlich SimConnect_Open in der nativen API
                    m_oSimConnect = new SimConnect("Simconnect - Simvar test", this.Handle, WM_USER_SIMCONNECT, null, 0);

                    /// Lauschen auf connect- und quit-Nachrichten
                    m_oSimConnect.OnRecvOpen += new SimConnect.RecvOpenEventHandler(SimConnect_OnRecvOpen);
                    m_oSimConnect.OnRecvQuit += new SimConnect.RecvQuitEventHandler(SimConnect_OnRecvQuit);

                    /// Lauschen auf Ausnahmen
                    m_oSimConnect.OnRecvException += new SimConnect.RecvExceptionEventHandler(SimConnect_OnRecvException);

                    /// Empfange simobject Daten-Abrufe                    
                    m_oSimConnect.OnRecvSimobjectData += new SimConnect.RecvSimobjectDataEventHandler(ctHandler);
                    if (m_oSimConnect != null) ConnectButton.Text = "Disconnect";                    
                }
                catch (COMException ex)
                {
                    Console.WriteLine("Verbindung zum Host fehlgeschlagen: " + ex.Message);
                }
            else Disconnect();
        }

        public void Disconnect()
        {
            Console.WriteLine("Disconnect");

            if (m_oSimConnect != null)
            {
                // Freigeben der Ressourcen analog SimConnect_Close()                
                m_oSimConnect.Dispose();
                m_oSimConnect = null;
                if (serialPort1.IsOpen) serialPort1.Close();
                Registriert = false;
                ConnectButton.Text = "Connect";
            }
        }

        private void ctHandler(SimConnect sender, SIMCONNECT_RECV_SIMOBJECT_DATA data)
        {
            switch (data.dwRequestID) // Welcches Datum wurde geliefert
            {
                case 0:
                    label1.Text = Math.Round((double)data.dwData[0]).ToString() + " ft";
                    break;
                case 1:
                    label2.Text = Math.Round((double)data.dwData[0]).ToString() + " kts";
                    break;
                case 2:
                    label3.Text = Math.Round((double)data.dwData[0]).ToString();
                    double x = (double)data.dwData[0];
                    break;
            }
            string s = ";";
            if (serialPort1.IsOpen) serialPort1.Write(label1.Text + s + label2.Text + s + label3.Text + s);
            Console.WriteLine("Daten Message empfangen");
            Console.WriteLine(data.dwRequestID.ToString());
        }

        private void RegisterClick(object sender, EventArgs e)
        {
            Register();
        }


        //Registrieren der Abfragen
        private void Register()
        {
            if (!serialPort1.IsOpen) serialPort1.Open();
            if ((!Registriert) && (m_oSimConnect != null)) // verhindern, dass diese Routine zwei Mal ausgeführt wird
            {

                m_oSimConnect.AddToDataDefinition(eDef, "INDICATED ALTITUDE", "Feet", SIMCONNECT_DATATYPE.FLOAT64, 0.0f, SimConnect.SIMCONNECT_UNUSED);
                m_oSimConnect.RegisterDataDefineStruct<double>(eDef);
                m_oSimConnect.RequestDataOnSimObject(eRequest, eDef, 0, SIMCONNECT_PERIOD.SECOND, SIMCONNECT_DATA_REQUEST_FLAG.CHANGED, 0, 0, 0);

                eDef = DEFINITION.Speed;
                eRequest = REQUEST.Speed;
                m_oSimConnect.AddToDataDefinition(eDef, "AIRSPEED INDICATED", "Knots", SIMCONNECT_DATATYPE.FLOAT64, 0.0f, SimConnect.SIMCONNECT_UNUSED);
                m_oSimConnect.RegisterDataDefineStruct<double>(eDef);
                m_oSimConnect.RequestDataOnSimObject(eRequest, eDef, 0, SIMCONNECT_PERIOD.SECOND, SIMCONNECT_DATA_REQUEST_FLAG.CHANGED, 0, 0, 0);

                eDef = DEFINITION.Gears;
                eRequest = REQUEST.Gears;
                m_oSimConnect.AddToDataDefinition(eDef, "GEAR POSITION", "Enum", SIMCONNECT_DATATYPE.FLOAT64, 0.0f, SimConnect.SIMCONNECT_UNUSED);
                m_oSimConnect.RegisterDataDefineStruct<double>(eDef);
                m_oSimConnect.RequestDataOnSimObject(eRequest, eDef, 0, SIMCONNECT_PERIOD.SECOND, SIMCONNECT_DATA_REQUEST_FLAG.CHANGED, 0, 0, 0);
                Registriert = true;
            } 

            Console.WriteLine("Registriert");
        }

        // Flugsimulator wurde gestartet
        private void SimConnect_OnRecvOpen(SimConnect sender, SIMCONNECT_RECV data)
        {            
            if (m_oSimConnect != null) Register(); // Wenn die Verbindung steht, koennen die Abfragen registriert werden
        }
        // Flugsimulator wurde beendet
        private void SimConnect_OnRecvQuit(SimConnect sender, SIMCONNECT_RECV data)
        {
            Console.WriteLine("SimConnect_OnRecvQuit");
            Console.WriteLine("Flugsimulator beendet");
            Disconnect();
        }

        //Ausnahmebehandlung
        private void SimConnect_OnRecvException(SimConnect sender, SIMCONNECT_RECV_EXCEPTION data)
        {
            SIMCONNECT_EXCEPTION eException = (SIMCONNECT_EXCEPTION)data.dwException;
            Console.WriteLine("SimConnect_OnRecvException: " + eException.ToString());
        }
    }

}
