/**
 * @overview JavaScript-Code für deploy.html. Implementiert die Funktion
 * {@link deployContract|deployContract()}, die den Vertrag auf die Blockchain
 * lädt.
 * @author Lars Hupel
 * @author Sylvester Tremmel
 */

/**
 * @summary Erstellt und versendet eine Ethereum-Transaktion, um den
 * Schere-Stein-Papier-Vertrag auf die Blockchain zu laden und wartet auf die
 * Bestätigung der Transaktion.
 * 
 * @description Absender der Transaktion ist der aktuell in MetaMask
 * eingestellte Account, Transaktionsbetrag (und damit Spieleinsatz) ist
 * {@link stake} aus commons.js. Vor Versand der Transaktion wird das Element
 * mit der ID "dply-pend" als Wartemeldung angezeigt (siehe {@link show}). Im
 * Erfolgsfall wird das Element mit der ID "dply-succ" angezeigt und die Adresse
 * des neuen Vertrages in dieses Element und in die URL des Play-Links
 * eingefügt. Im Fehlerfall wird das Element "dply-fail" angezeigt.
 * @throws Wirft jeglichen Fehler, der von MetaMask oder Web3js produziert wird.
 */
async function deployContract() {
  try {
    // Adresse von Spieler 1 über MetaMask beziehen.
    const player1 = await getAccount();
    // Adresse von Spieler 2 aus dem Textfeld auslesen.
    const player2 = document.getElementById("player2").value;

    // JSON-Repräsentation der ABI laden, interpretieren und damit ein Contract-
    // Object erstellen.
    const abi = await fetchABI();
    const contract = new window.web3.eth.Contract(JSON.parse(abi));

    // Vertragscode laden und damit eine Deployment-Transaktion generieren.
    // deploy() ist letzlich der Konstruktor des Vertrags (siehe game.sol), den
    // Web3js hier als JavaScript-Methode zur Verfügung stellt.
    const bin = await fetchContract();
    const tx = contract.deploy({
      data: `0x${bin}`,
      arguments: [player2]
    });

    // Wartemeldung anzeigen.
    show("dply-pend");

    // Deployment-Transaktion versenden.
    const receipt = await tx.send({
      from: player1,
      value: stake
    });

    // Adresse des neuen Vertrages auslesen und ausgeben.
    const addr = receipt.options.address;
    document.getElementById("play-link").href = `play.html?addr=${addr}`;
    document.getElementById("dply-succ").innerHTML = `Deployed contract at <code>${addr}</code>!`;
    
    // Erfolgsmeldung anzeigen
    show("dply-succ");
  }
  catch (err) {
    // Fehlermeldung anzeigen (und Fehler weiter eskalieren).
    show("dply-fail");
    throw err;
  }
}
