import RPi.GPIO as GPIO
import asyncio
import simpleobsws
import logging

Switch1 = 16
Switch2 = 18
BounceTime = 500

ObsIP = '192.168.178.20'
ObsPort = 4444
ObsPass = '****'
SceneName = ['Welcome', 'Gameplay']
AudioSource = 'Mikrofon'

logging.basicConfig(level=logging.INFO)
loop = asyncio.get_event_loop()

async def toggleAudioMute():
    global ObsIP, ObsPort, ObsPass
    global AudioSource
    ws = simpleobsws.obsws(host=ObsIP, port=ObsPort, password=ObsPass)
    await ws.connect()
    result = await ws.call('GetSourcesList')
    if result.get('status') == 'ok':
        for src in result.get('sources'):
            if src.get('name') == AudioSource:
                break
    if src.get('name') != AudioSource:
        logging.error("No audio source '%s'.", AudioSource)
        return
    data = {'source':AudioSource}
    result = await ws.call('ToggleMute', data)
    if result.get('status') == 'ok':
        logging.info("Toggled mute on '%s'.", AudioSource)
    await ws.disconnect()

async def switchToScene(SceneNr):
    global ObsIP, ObsPort, ObsPass
    global SceneName
    ws = simpleobsws.obsws(host=ObsIP, port=ObsPort, password=ObsPass)
    await ws.connect()
    result = await ws.call('GetCurrentScene')
    if result.get('name') == SceneName[SceneNr]:
        logging.info("Scene '%s' already active.", SceneName[SceneNr])
        return
    data = {'scene-name':SceneName[SceneNr]}
    result = await ws.call('SetCurrentScene', data)
    if result.get('status') == 'ok':
        logging.info("Switched to scene '%s'.", SceneName[SceneNr])
    await ws.disconnect()

def buttonPress(pin):
    global loop
    if loop is None:
        return
    state = GPIO.input(pin)
    if pin == Switch1:
        asyncio.run_coroutine_threadsafe(switchToScene(state), loop)
    if pin == Switch2:
        asyncio.run_coroutine_threadsafe(toggleAudioMute(), loop)

try:
    GPIO.setmode(GPIO.BOARD)
    GPIO.setup(Switch1, GPIO.IN, pull_up_down=GPIO.PUD_UP)
    GPIO.setup(Switch2, GPIO.IN, pull_up_down=GPIO.PUD_UP)
    GPIO.add_event_detect(Switch1, GPIO.BOTH,
        callback=buttonPress, bouncetime=BounceTime)
    GPIO.add_event_detect(Switch2, GPIO.BOTH,
        callback=buttonPress, bouncetime=BounceTime)
    state = GPIO.input(Switch1)
    loop.run_until_complete(switchToScene(state))
    loop.run_forever()
except:
    loop.close()
    GPIO.cleanup()
