import RPi.GPIO as GPIO
import asyncio
import time
from subprocess import call

def buttonPress(pin):
    if not GPIO.input(5):
        print("Shutdown")
        call(['shutdown', '-h', 
              'now'], shell=False)

GPIO.setmode(GPIO.BOARD)
GPIO.setup(5, GPIO.IN)
GPIO.add_event_detect(
    5, GPIO.BOTH, 
    callback=buttonPress,
    bouncetime=100
)

try:
    loop = asyncio.get_event_loop()
    loop.run_forever()
except:
    loop.close()
