import RPi.GPIO as GPIO
from time import sleep, time

triggerPin = 11
echoPin = 13
t0 = None
t1 = None

def echoEvent(pin):
  global t0, t1
  if pin==echoPin:
    if (GPIO.input(echoPin)
       and not t0):
      t0 = time()
    elif (not GPIO.input(echoPin)
         and t0
         and not t1):
      t1 = time()
      print ("Entfernung: %.1f cm"
        % ((t1-t0)
          *34300/2))
      t0 = None
      t1 = None

def Dist():
  global triggerPin
  GPIO.output(triggerPin, GPIO.LOW)
  sleep(0.000010)
  GPIO.output(triggerPin, GPIO.HIGH)

GPIO.setmode(GPIO.BOARD)
GPIO.setup(triggerPin, GPIO.OUT,
     initial=GPIO.HIGH)
GPIO.setup(echoPin, GPIO.IN)
GPIO.add_event_detect(echoPin,
     GPIO.BOTH, callback=echoEvent)
try:
  while True:
    Dist()
    sleep(1)

except KeyboardInterrupt:
  GPIO.cleanup()
