import RPi.GPIO as GPIO
from time import sleep, time

triggerPin = 11
echoPin = 13

def Dist():
  GPIO.output(triggerPin, GPIO.LOW)
  sleep(0.00001)
  GPIO.output(triggerPin, GPIO.HIGH)

  while GPIO.input(echoPin) == 0:
    t0 = time()
  while GPIO.input(echoPin) == 1:
    t1 = time()
  return (t1-t0)*34300/2

GPIO.setmode(GPIO.BOARD)
GPIO.setup(triggerPin, GPIO.OUT,
           initial=GPIO.HIGH)
GPIO.setup(echoPin, GPIO.IN)

try:
  while True:
    print ("Entfernung: %.1f cm" 
           % Dist())
    sleep(1)

except KeyboardInterrupt:
  GPIO.cleanup()
