@echo off
set workdir=%~dp0
whoami /groups | find "S-1-16-12288" > nul
if not errorlevel 1 (
  %windir%\System32\more +16 "%~f0" > "%workdir%%~n0-temp.ps1"
  powershell -NoProfile -ExecutionPolicy Bypass -File "%workdir%%~n0-temp.ps1" %*
  del %workdir%%~n0-temp.ps1
  exit /b
  )
color 0C
echo.
echo Dieses Skript funktioniert nur mit Administratorrechten!
pause
goto :eof
  
*** Ab hier PowerShell ***
$Details = $true # $true fr "Immer Details anzeigen"

function Ausgabe([string[]] $Pfade, [bool] $Details) {
  ForEach ($Pfad in $Pfade) {
    if (Test-Path -Path $Pfad) {
      Write-Host `n$Pfad -ForegroundColor Yellow -BackgroundColor Black
    }
	else {
      Write-Host "`n$Pfad nicht gefunden." -ForegroundColor Red -BackgroundColor Black
      continue
    }

    $ISO = $Null
    if (Test-Path -Path $Pfad -Include *.iso) {
      $ISO = $Pfad
      Mount-DiskImage $Pfad | Out-Null
      $Pfad = (Get-DiskImage $Pfad | Get-Volume).DriveLetter + ":\"
    }

    if ($Details) {
      if (Test-Path -Path $Pfad -Include *.swm,*.esd,*.wim) {
        $Index = (Get-WindowsImage -ImagePath $Pfad).ImageIndex
        ForEach ($Nummer in $Index) {
          Dism.exe /Get-ImageInfo /Imagefile:$Pfad /index:$Nummer
        }
      }
      else {
        $Wims = Get-ChildItem -Path $Pfad -include *.wim,*.esd,*.swm -Recurse 
        ForEach ($Pfad in $Wims) {
          $Index = (Get-WindowsImage -ImagePath $Pfad).ImageIndex
          ForEach ($Nummer in $Index) {
            Dism.exe /Get-ImageInfo /Imagefile:$Pfad /index:$Nummer
          }
        } 
      }
    }
    else {
      if (Test-Path -Path $Pfad -Include *.swm,*.esd,*.wim) {
        Dism.exe /Get-ImageInfo /Imagefile:$Pfad
      }
      else {
        foreach ($wim in (Get-ChildItem -path $Pfad -Include *.wim,*.esd,*.swm -Recurse)) {
          Dism.exe /Get-ImageInfo /Imagefile:$wim
        }
      }
    }

    If ($ISO) {
      Dismount-DiskImage $ISO | Out-Null
    }
  }
}

$Dateien = @()
ForEach ($arg in $Args) {
  if ($arg -eq "-v" -or $arg -eq "/v" -or $arg -eq "--verbose") {
    $Details = $true
  }
  else {
    $Dateien += $arg
  }
}

Ausgabe $Dateien $Details

Write-Host "`r`n`r`n(Enter zum Beenden)" -NoNewline
Read-Host
