import qrcode

vwz = "Rechnung 123456789"
iban = "DE02100500000054540402"
bic = "BELADEBE"
recipient = "Beispielfirma Musterdörfer"
amount = 55.25
filename = "epc_qr"

# The docs can be found here: https://pypi.org/project/qrcode/
qr = qrcode.QRCode(error_correction=qrcode.constants.ERROR_CORRECT_M)

qr.add_data("BCD\n")
qr.add_data("002\n")
qr.add_data("1\n")
qr.add_data("SCT\n")
qr.add_data(bic+"\n")
qr.add_data(recipient[0:69]+"\n")
qr.add_data(iban+"\n")
qr.add_data("EUR"+str(amount)+"\n")
qr.add_data("\n")
qr.add_data("\n")
qr.add_data(vwz[0:139]+"\n")
qr.make(fit=True)
img = qr.make_image()
img.save(filename+".png")
