import RPi.GPIO as GPIO
import board
import busio
# https://github.com/adafruit/Adafruit_CircuitPython_HT16K33
from adafruit_ht16k33 import segments
from time import sleep, time

#busno = 0x01
address = 0x70
# BCM-Pin-Nummerierung
triggerPin= 17
echoPin = 27
buttonPin = 22
mStatus = 0
t0 = 0
t1 = 0

def sendTrigger():
  global triggerPin
  GPIO.output(triggerPin, GPIO.LOW)
  sleep(0.000010)
  GPIO.output(triggerPin, GPIO.HIGH)

def echoEvent(pin):
  global display, t0, t1
  if pin==echoPin:
    if (GPIO.input(echoPin) and not t0):
      t0 = time()
    elif (not GPIO.input(echoPin) and t0 and not t1):
      t1 = time()
      d = round((t1 - t0)*343000/2)/10 # cm
      display.fill(0)
      display.print(d, decimal=1)
      t0 = None
      t1 = None

def buttonPress(pin):
  global mStatus
  if mStatus==0:
    mStatus = 1
    sendTrigger()
    mStatus = 0

i2c = busio.I2C(board.SCL, board.SDA)
display = segments.Seg7x4(i2c) 

# clear
display.fill(0)

# GPIO.setmode(GPIO.BOARD)
GPIO.setup(buttonPin, GPIO.IN, pull_up_down=GPIO.PUD_UP)
GPIO.setup(triggerPin, GPIO.OUT, initial=GPIO.HIGH)
GPIO.setup(echoPin, GPIO.IN)
GPIO.add_event_detect(echoPin, GPIO.BOTH, callback=echoEvent)
GPIO.add_event_detect(buttonPin, GPIO.BOTH, callback=buttonPress, bouncetime=500)

try:
  while True:
    sleep(10)

except KeyboardInterrupt:
  GPIO.cleanup()
