import RPi.GPIO as GPIO
from smbus import SMBus
from time import sleep, time

OSCILLATOR = 0x20
DISPLAY = 0x80
DIGIT = [0x00, 0x02, 0x06, 0x08]

SSEG = {
  0: 0x3F, 1: 0x06, 2: 0x5B, 3: 0x4F, 4: 0x66,
  5: 0x6d, 6: 0x7d, 7: 0x07, 8: 0x7F, 9: 0x67
}

busno = 0x01
address = 0x70
triggerPin= 11
echoPin = 13
buttonPin = 15
mStatus = 0
t0 = 0
t1 = 0

def showDigit(i:int, j:int):
  global i2c
  POINT = [0x00, 0x00, 0x80, 0x00]
  if i in range(4) and j in range(10):
    c = SSEG[j] | POINT[i]  # Dezimalpunkt
    i2c.write_byte_data(address, DIGIT[i], c)

def sendTrigger():
  global triggerPin
  GPIO.output(triggerPin, GPIO.LOW)
  sleep(0.000010)
  GPIO.output(triggerPin, GPIO.HIGH)

def echoEvent(pin):
  global t0, t1
  if pin==echoPin:
    if (GPIO.input(echoPin) and not t0):
      t0 = time()
    elif (not GPIO.input(echoPin) and t0 and not t1):
      t1 = time()
      d = round((t1 - t0)*343000/2) # mm
      for i in range(4):
        showDigit(3-i, (d//(10**i))%10)
      t0 = None
      t1 = None

def buttonPress(pin):
  global mStatus
  if mStatus==0:
    mStatus = 1
    sendTrigger()
    mStatus = 0

i2c = SMBus(busno)
for i in range(0x10):
  i2c.write_byte_data(address, i, 0x00)
i2c.write_byte(address, OSCILLATOR|0x01)
i2c.write_byte(address, DISPLAY|0x01)

GPIO.setmode(GPIO.BOARD)
GPIO.setup(buttonPin, GPIO.IN, pull_up_down=GPIO.PUD_UP)
GPIO.setup(triggerPin, GPIO.OUT, initial=GPIO.HIGH)
GPIO.setup(echoPin, GPIO.IN)
GPIO.add_event_detect(echoPin, GPIO.BOTH, callback=echoEvent)
GPIO.add_event_detect(buttonPin, GPIO.BOTH,
                      callback=buttonPress, bouncetime=500)

try:
  while True:
    sleep(10)

except KeyboardInterrupt:
  i2c.write_byte(address, OSCILLATOR|0x00)
  GPIO.cleanup()
