/***********************************************************/
/*                                                         */
/*                  File:  decode_linux.c                  */
/*                                                         */
/*                Find and Print Hidden Text               */
/*                                                         */
/***********************************************************/
/*                                                         */
/*                  Compiler: cc (Linux)                   */
/*                                                         */
/***********************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>


/************************************************************
*  The text must be ISO-8859-15 or UTF-8 coded.
*  Newlines are handled as if they were single spaces.
*  Multiple newlines in a row are handled as if they
*  were just one. So, joining two paragraph has no
*  effect on the outcome.
************************************************************/
void decodeHiddenText(unsigned char* text, const char* password)
{
  int i,j,k;
  int length = strlen(text);

  for (i=0, k=1, j=0; i<length; i++, k++)
  {
    /* handle newline and carriage return characters */
    if ((text[i]=='\r')||(text[i]=='\n'))
    {
      while ((text[i+1]=='\r')||(text[i+1]=='\n'))
        if (++i>=(length-1)) break;
      text[i]=' ';
    }

    /* handle German Umlauts in UTF-8*/
    if (text[i]==0xC3)  text[++i]+=0x40;

    /* print the character */
    if (k==password[j])
    {
      switch (text[i])
      {
        case 0xE4: printf("ä"); break;
        case 0xF6: printf("ö"); break;
        case 0xFC: printf("ü"); break;
        case 0xC4: printf("Ä"); break;
        case 0xD6: printf("Ö"); break;
        case 0xDC: printf("Ü"); break;
        case 0xDF: printf("ß"); break;
        default:   printf("%c", text[i]);
      }
      printf(" ");
      k=0;
      if (++j==strlen(password))  j=0;
    }
  }
}


int main(int argc, char* argv[])
{
  int fileLength;
  char password[50]="";
  FILE *in;
  unsigned char text[65535];

  //--- check programm parameters -------------------------------------------
  if (argc!=3)
  {
    printf("usage: decode_linux <filename> <password>\n");
    return (0);
  }

  strncpy(password, argv[2], 50);

  if ((in=fopen(argv[1],"rb"))==NULL)
  {
    printf("\ncan not open %s \n", argv[1]);
    return (0);
  }

  //----------- read file data ----------------------------------------------
  fseek(in, 0L, SEEK_END);
  fileLength=ftell(in);
  fseek(in, 0L, SEEK_SET);
  printf("\nDecoded text:\n\n");

  if (fileLength>=65535)
  {
    printf("\nfile too large\n");
    return (0);
  }
  fread(text, fileLength, 1, in);
  text[fileLength]=0;

  //----------- process file data -------------------------------------------
  decodeHiddenText(text, password);

  //----------- clean up ----------------------------------------------------
  fclose(in);
  printf("\n\n");
}

