#!/bin/bash
#
# fritz_docsis_2_influx_lines.sh
#
# read DOCSIS Information from Fritzbox Cable Routers
# and write these infos in a format that can be
# written into an influx database
#
# example: fritz_docsis_2_influx_lines.sh | influx write -b <bucket>

# ---------------------------------------------
# please define your settings for your fritzbox
# ---------------------------------------------
fritzbox="192.168.178.1"
user="ct"
pass="geheim"

#
# nothing to be changed from here
#

# --------------------
# cache Login with SID
# --------------------
sidfile=/run/shm/$fritzbox.sid
[ ! -f $sidfile ] && echo "0000000000000000" > $sidfile
sid=$(cat $sidfile)

# --------------------
# check Login with SID
# --------------------
result=$(curl -s "http://$fritzbox/login_sid.lua?sid=$sid" | grep -c "0000000000000000")
if [ $result -gt 0 -o $sid = "0000000000000000" ]; then
  challenge=$(curl -s http://$fritzbox/login_sid.lua | grep -o "<Challenge>.*</Challenge>" | sed 's,</*Challenge>,,g')
  hash=$(echo -n "$challenge-$pass" | sed -e 's,.,&\n,g' | tr '\n' '\0' | md5sum | grep -o "[0-9a-z]\{32\}")
  curl -s "http://$fritzbox/login_sid.lua" -d "response=$challenge-$hash" -d 'username='${user} | grep -o "<SID>[a-z0-9]\{16\}" | cut -d'>' -f 2 > $sidfile
fi
sid=$(cat $sidfile)

# --------------------------------
# read DOCSIS-Infos (page=docInfo)
# --------------------------------
docsis=$(curl -s "http://$fritzbox/data.lua" -d "xhr=1&sid=$sid&lang=de&page=docInfo&xhrId=all&no_sidrenew")

# AVM may change the modulation entry from 'type' to 'modulation' in later OS version
if [ "_"$(echo ${docsis} | jq -r ".data.channelUs.docsis30[0].type") = "_null" ]; then
  qam="modulation"
else
  qam="type"
fi

# get nr. of up-/downstream channels
channelUs=$(echo ${docsis} | jq ".data.channelUs.docsis30[].powerLevel" | wc -l)
channelDs=$(echo ${docsis} | jq ".data.channelDs.docsis30[].powerLevel" | wc -l)

# read upstream channels
for (( c=0; c<$channelUs; c++ )); do
  channelID[$c]=$(echo ${docsis}  | jq -r ".data.channelUs.docsis30[$c].channelID")
  channel[$c]=$(echo ${docsis}    | jq -r ".data.channelUs.docsis30[$c].channel")
  modulation[$c]=$(echo ${docsis} | jq -r ".data.channelUs.docsis30[$c].$qam" | sed 's/[^0-9.]//g')
  powerLevel[$c]=$(echo ${docsis} | jq -r ".data.channelUs.docsis30[$c].powerLevel")
  frequency[$c]=$(echo ${docsis}  | jq -r ".data.channelUs.docsis30[$c].frequency")

  echo "docsis,mode=up,channel=${channelID[$c]} Modulation=${modulation[$c]}"
  echo "docsis,mode=up,channel=${channelID[$c]} PowerLevel=${powerLevel[$c]}"
  echo "docsis,mode=up,channel=${channelID[$c]} Frequenz=${frequency[$c]}"
done

# read downstream channels
for (( c=0; c<$channelDs; c++ )); do
  channelID[$c]=$(echo ${docsis}  | jq -r ".data.channelDs.docsis30[$c].channelID")
  channel[$c]=$(echo ${docsis}    | jq -r ".data.channelDs.docsis30[$c].channel")
  modulation[$c]=$(echo ${docsis} | jq -r ".data.channelDs.docsis30[$c].$qam" | sed 's/[^0-9.]//g')
  powerLevel[$c]=$(echo ${docsis} | jq -r ".data.channelDs.docsis30[$c].powerLevel")
  frequency[$c]=$(echo ${docsis}  | jq -r ".data.channelDs.docsis30[$c].frequency")
  latency[$c]=$(echo ${docsis}    | jq -r ".data.channelDs.docsis30[$c].latency")
  corrErrors[$c]=$(echo ${docsis} | jq -r ".data.channelDs.docsis30[$c].corrErrors")
  nonCorrErrors[$c]=$(echo ${docsis} | jq -r ".data.channelDs.docsis30[$c].nonCorrErrors")

  echo "docsis,mode=down,channel=${channelID[$c]} Modulation=${modulation[$c]}"
  echo "docsis,mode=down,channel=${channelID[$c]} PowerLevel=${powerLevel[$c]}"
  echo "docsis,mode=down,channel=${channelID[$c]} Frequenz=${frequency[$c]}"
  echo "docsis,mode=down,channel=${channelID[$c]} Latenz=${latency[$c]}"
  echo "docsis,mode=down,channel=${channelID[$c]} korrFehler=${corrErrors[$c]}"
  echo "docsis,mode=down,channel=${channelID[$c]} Fehler=${nonCorrErrors[$c]}"
done

